package communitiesGraph;

import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.utils.progress.Progress;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * Created with IntelliJ IDEA.
 * User: nikita
 * Date: 21.04.13
 * Time: 21:53
 * To change this template use File | Settings | File Templates.
 */
public class MyExporterWithCliques extends MyExporterCSV {

    protected List<HashSet<Node>> cliques;

    public MyExporterWithCliques(List<HashSet<Node>> cliques) {
        this.cliques = cliques;
    }

    public boolean execute() {
        GraphModel graphModel = workspace.getLookup().lookup(GraphModel.class);
        Graph graph = null;
        if (exportVisible) {
            graph = graphModel.getGraphVisible();
        } else {
            graph = graphModel.getGraph();
        }

        if (normalize) {
            calculateMinMax(graph);
        }
        try {
            exportData(graph);
            writer.append(EOL);
            exportCliquesData(graph);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }

        return !cancel;
    }

    protected void exportCliquesData(Graph graph) throws IOException {
        Progress.start(progressTicket, cliques.size());

        String prefix = "C";
        int i = 0;
        for (Set<Node> clique : cliques) {
            writeClique(String.valueOf(++i), prefix + String.valueOf(i), clique);
            Progress.progress(progressTicket);
        }

        Progress.finish(progressTicket);
    }

    protected void writeClique(String cliqueId, String name, Collection<Node> nodes) throws IOException {
        writer.append(cliqueId)
                .append(SEPARATOR)
                .append(name);

        for (Node node : nodes) {
            writer.append(SEPARATOR);
            String label = node.getNodeData().getLabel();
            if (label == null) {
                writer.append(node.getNodeData().getId());
            } else {
                writer.append(label);
            }
        }

        writer.append(EOL);
    }

}
