package communitiesGraph;

import communities.parseciteceer.Database;
import communities.parseciteceer.GraphDB;
import org.gephi.graph.api.*;
import org.gephi.graph.api.Node;
import org.gephi.io.exporter.api.ExportController;
import org.gephi.io.exporter.spi.GraphExporter;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.neo4j.graphdb.*;
import org.openide.util.Lookup;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;

/**
 * Created with IntelliJ IDEA.
 * User: nikita
 * Date: 22.03.13
 * Time: 1:02
 * To change this template use File | Settings | File Templates.
 */
public class GraphFromGraphDB extends GraphCreator implements IScientificGraph {
    private HashMap<org.neo4j.graphdb.Node, Node> nodeToNode;

    private long dbWorkTime = 0;

    public long getDbWorkTime() {
        return dbWorkTime;
    }

    public GraphFromGraphDB(String request) throws Exception {
        super(request);

        nodeToNode = new HashMap<>();
        createFromNeo4j();
        setNodeSize();
    }

    private void createFromNeo4j() throws Exception {
        //long startTime = System.currentTimeMillis();
        int authorID = getAuthorID(requestSearch);

        dbWorkTime = 0;
        long time = System.currentTimeMillis();
        GraphDB graphDB = new GraphDB();
        dbWorkTime += System.currentTimeMillis() - time;
        try {
            time = System.currentTimeMillis();
            org.neo4j.graphdb.Node dbAuthorNode = graphDB.getAuthorByID(authorID);
            dbWorkTime += System.currentTimeMillis() - time;
            mainNode = createNode(dbAuthorNode);
            graph.addNode(mainNode);


            //long beforeCreateCoAuthors = System.currentTimeMillis();
            time = System.currentTimeMillis();
            Iterable<org.neo4j.graphdb.Node> coAuthors = graphDB.getCoAuthors(dbAuthorNode);
            dbWorkTime += System.currentTimeMillis() - time;
            for (org.neo4j.graphdb.Node otherAuthor : coAuthors) {
                Node otherAuthorNode = createNode(otherAuthor);
                graph.addNode(otherAuthorNode);
                Edge edge = graphModel.factory().newEdge(mainNode, otherAuthorNode, CO_AUTHOR_RELATION_SIZE, false);
                graph.addEdge(edge);
            }

            //long beforeCreateCitators = System.currentTimeMillis();
            time = System.currentTimeMillis();
            Iterable<org.neo4j.graphdb.Node> citators = graphDB.getCitators(dbAuthorNode);
            dbWorkTime += System.currentTimeMillis() - time;
            for (org.neo4j.graphdb.Node otherAuthor : citators) {
                Node otherAuthorNode = createNode(otherAuthor);
                graph.addNode(otherAuthorNode);
                Edge edge = graphModel.factory().newEdge(mainNode, otherAuthorNode, CITATOR_RELATION_SIZE, false);
                graph.addEdge(edge);
            }

            //long beforeCreateRelationsCoAuthors = System.currentTimeMillis();
            for (org.neo4j.graphdb.Node dbNode : coAuthors) {
                addRelations(dbNode, graphDB);
            }
            //long beforeCreateRelationsCitators = System.currentTimeMillis();
            for (org.neo4j.graphdb.Node dbNode : citators) {
                addRelations(dbNode, graphDB);
            }

            //long endTime = System.currentTimeMillis();
/*            System.out.println("\nFrom start to creates coauthors: " + (beforeCreateCoAuthors - startTime));
            System.out.println("Create coauthors: " + (beforeCreateCitators - beforeCreateCoAuthors));
            System.out.println("Create citators: " + (beforeCreateRelationsCoAuthors - beforeCreateCitators));
            System.out.println("Create relations coauthors: " + (beforeCreateRelationsCitators - beforeCreateRelationsCoAuthors));
            System.out.println("Create relations citators: " + (endTime - beforeCreateRelationsCitators));

            System.out.println("count of nodes: " + graph.getNodes().toArray().length);
            System.out.println("count of relations: " + graph.getEdges().toArray().length);*/
        } finally {
            graphDB.shutdown();
        }
    }

    private void addRelations(org.neo4j.graphdb.Node dbNode, GraphDB graphDB) {
        Node authorNode = nodeToNode.get(dbNode);

        if (authorNode != null) {
            long time = System.currentTimeMillis();
            Iterable<org.neo4j.graphdb.Node> authors = graphDB.getCoAuthorsAndCitators(dbNode);
            dbWorkTime += System.currentTimeMillis() - time;
            for (org.neo4j.graphdb.Node otherAuthor : authors) {
                Edge edge = createEdge(authorNode, otherAuthor, CITATOR_RELATION_SIZE, false);
                if (edge != null) {
                    graph.addEdge(edge);
                }
            }
        }
    }

    private Edge createEdge(Node sourceNode, org.neo4j.graphdb.Node dbEndNode, float relSize, boolean direction) {
        Node endNode = nodeToNode.get(dbEndNode);
        if (endNode != null) {
            return graphModel.factory().newEdge(sourceNode, endNode, relSize, direction);
        }
        return null;
    }

    private Node createNode(org.neo4j.graphdb.Node dbNode) {
        Integer authorID = getAuthorID(dbNode);
        Node node;
        if (!nodeToNode.containsKey(dbNode)) {
            node = graphModel.factory().newNode(authorID.toString());
            nodeToNode.put(dbNode, node);
            node.getNodeData().setLabel(getAuthorName(dbNode));
        } else {
            node = nodeToNode.get(dbNode);
        }
        return node;
    }

    private Integer getAuthorID(org.neo4j.graphdb.Node node) {
        return (Integer) node.getProperty(GraphDB.PK_AUTHOR_ID);
    }

    private String getAuthorName(org.neo4j.graphdb.Node node) {
        return (String) node.getProperty(GraphDB.PK_AUTHOR_NAME);
    }

    private int getAuthorID(String request) throws Exception {
        Database database = new Database();
        try {
            return database.getAuthorIdByName(request);
        } finally {
            database.closeConnection();
        }
    }
}
