import communitiesGraph.GraphFromGraphDB;
import communitiesGraph.IScientificGraph;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

/**
 * Created with IntelliJ IDEA.
 * User: nikita
 * Date: 28.09.12
 * Time: 14:59
 * To change this template use File | Settings | File Templates.
 */
@WebServlet(name = "Servlet")
public class Servlet extends HttpServlet {

    public void doPost(HttpServletRequest req, HttpServletResponse res)
            throws IOException, ServletException {
        IScientificGraph sGraph = null;
        try {
            final String searchRequest = req.getParameter("search_request");

            long startTime = System.currentTimeMillis();

            sGraph = new GraphFromGraphDB(searchRequest);
            final String filename = sGraph.saveGraphWithCliques();

            long endTime = System.currentTimeMillis();
            System.out.println(searchRequest + " time graph generate: " + (endTime - startTime));

            //Map<String, Integer> degreeC = communitiesGraph.SearchGraph.getDegreeCentrality(sGraph.getGraph());
            //Map<String, Integer> closenessC = Dijkstra.getClosenessCentrality(sGraph.getGraph());
            //Map<String, Integer> betwennessC = FloydWarshall.getBetwennessCentrality(sGraph.getGraph());

            //StringBuilder sb = new StringBuilder();

            /*sb.append("<table class=\"table\">\n");
            
            sb.append("<thead>\n");
            sb.append("<tr>\n");
            sb.append("<th>Author</th>\n");
            sb.append("<th>DegreeCentrality</th>\n");
            sb.append("<th>ClosenessCentrality</th>\n");
            sb.append("<th>BetwennessCentrality</th>\n");
            sb.append("</tr>\n");
            sb.append("</thead>\n");
            
            int tmp = degreeC.size();
            
            sb.append("<tbody>\n");
            for(String t : degreeC.keySet()) {
                sb.append("<td>");
                sb.append(t);
                sb.append("</td>\n");
                
                sb.append("<td>");
                sb.append(degreeC.get(t));
                sb.append("</td>\n");
                
                sb.append("<td>");
                sb.append(closenessC.get(t));
                sb.append("</td>\n");
                
                sb.append("<td>");
                sb.append(betwennessC.get(t));
                sb.append("</td>\n");
            }
            sb.append("</tbody>\n");
            
            sb.append("</table>\n");*/

            res.setContentType("text/html");

            PrintWriter out = res.getWriter();
            try {
                out.println(
                        "<!DOCTYPE html>\n" +
                                "<html>\n" +
                                "  <head>\n" +
                                "    <title>Scientific Search Page</title>\n" +
                                "\n" +
                                "      <link href=\"css/bootstrap.min.css\" rel=\"stylesheet\" media=\"screen\">\n" +
                                "  </head>\n" +
                                "  <body>\n" +
                                "    <div class=\"span9\">\n" +
                                "        <form class=\"form-search\" method=\"post\" action=\"scisearch\">\n" +
                                "            <div class=\"input-append\">\n" +
                                "                <input type=\"text\" name=\"search_request\" class=\"span4 search-query\">\n" +
                                "                <button type=\"submit\" class=\"btn\">Search</button>\n" +
                                "            </div>\n" +
                                "        </form>\n" +
                                "    </div>\n" +
                                "\n" +
                                "    <iframe src=\"index.html#" + filename + "\" frameborder=\"0\" class=\"span12\" height=\"600\"></iframe>\n" +
                                //sb.toString() +
                                "\n" +
                                "    <script src=\"http://code.jquery.com/jquery-latest.js\"></script>\n" +
                                "    <script src=\"js/bootstrap.min.js\"></script>\n" +
                                "  </body>\n" +
                                "</html>");
            } finally {
                out.close();
            }

            //res.sendRedirect("index.jsp#" + filename);
        } catch (Exception e) {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
        }
    }

}
