package GraphTesting;

import communitiesGraph.*;

/**
 * Created with IntelliJ IDEA.
 * User: nikita
 * Date: 23.03.13
 * Time: 16:19
 * To change this template use File | Settings | File Templates.
 */
public class Testing {

    String[] names = new String[]{
                    "kristina garber biologist",
                    "athman bouguettaya",
                    "koen bertels",
                    "uri m. ascher",
                    "marco bernardo",
                    "aaron brown",
                    "jeremy n. bailenson",
                    "david bainbridge",
                    "bonnie berger",
                    "clare boothe",
                    "john blitzer",
                    "torben g. andersen",
                    "matthias buck",
                    "yossi azar",
                    "shai avidan",
                    "jim blythe",
                    "aude billard",
                    "elisa bertino"};

    public void timeGenerationGraph() {
        XLSWriter writer = new XLSWriter("TimeGenerationGraph2.xls");
        Sheet timeGenerationSheet = writer.creteGraphDataSheet();

        /*calculateTime(new String[]{
        "kristina garber biologist",
        "athman bouguettaya",
        "koen bertels",
        "uri m. ascher",
        "marco bernardo"
}, 50, timeGenerationSheet);      */

        /*calculateTime(new String[]{
              *//*  "aaron brown",
                "jeremy n. bailenson",
                "david bainbridge",*//*
                "bonnie berger",
                "clare boothe",
                "john blitzer"
        }, 10, timeGenerationSheet);*/

        calculateTime(new String[]{
                "torben g. andersen",
                "matthias buck",
                "yossi azar",
                /* "shai avidan",
               "jim blythe",
               "aude billard",
               "elisa bertino"*/
        }, 5, timeGenerationSheet);

        writer.write();
    }

    private void calculateTime(String[] names, int countIteration, Sheet timeGenerationSheet) {
        for (String name : names) {
            long sumTime = 0;
            IScientificGraph sGraph;

/*            try {
                new SearchGraph("kristina garber biologist", EnumSearch.SearchAuthor);
            } catch (Exception e) {
                e.printStackTrace();
            }*/

            for (int i = 0; i < countIteration; i++) {
                try {
                    long startTime = System.currentTimeMillis();
                    sGraph = new SearchGraph(name, EnumSearch.SearchAuthor);
                    sGraph.saveGraphCSV();
                    long endTime = System.currentTimeMillis();

                    sumTime += (endTime - startTime);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            timeGenerationSheet.addTimeGeneration("0", name, 0, 0, sumTime / countIteration);
            System.out.println("done: " + name + " " + sumTime / countIteration);
        }
    }

    public void timeDBWork() {
        XLSWriter writer = new XLSWriter("TimeDBWork7.xls");
        Sheet timeGenerationSheet = writer.creteGraphDataSheet();

        /*calculateGraphDBTime(new String[]{
              "kristina garber biologist",
              "athman bouguettaya",
              "koen bertels",
              "uri m. ascher",
              "marco bernardo",
              "aaron brown"
      }, 50, timeGenerationSheet);*/

        /*calculateGraphDBTime(new String[]{
              "jeremy n. bailenson",
              "david bainbridge",
              "bonnie berger",
              "clare boothe",
              "john blitzer"
      }, 10, timeGenerationSheet);*/

        calculateGraphDBTime(new String[]{
                /*     "torben g. andersen",
              "matthias buck",
              "yossi azar",
              "shai avidan" */
                "jim blythe",
                /*  "aude billard",
               "elisa bertino"*/
        }, 2, timeGenerationSheet);

        writer.write();
    }

    private void calculateGraphDBTime(String[] names, int countIteration, Sheet timeGenerationSheet) {
        for (String name : names) {
            long sumTime = 0;
            GraphFromGraphDB sGraph;

            try {
                new GraphFromGraphDB("kristina garber biologist");
            } catch (Exception e) {
                e.printStackTrace();
            }

            for (int i = 0; i < countIteration; i++) {
                try {
                    sGraph = new GraphFromGraphDB(name);
                    sGraph.saveGraphCSV();

                    sumTime += sGraph.getDbWorkTime();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            timeGenerationSheet.addTimeGeneration("0", name, 0, 0, sumTime / countIteration);
            System.out.println("done: " + name + " " + sumTime / countIteration);
        }
    }

    public void timeSQLDBWork() {
        XLSWriter writer = new XLSWriter("TimeSQLDBWork6.xls");
        Sheet timeGenerationSheet = writer.creteGraphDataSheet();

        /*calculateMySQLDBTime(new String[]{
                "kristina garber biologist",
                "athman bouguettaya",
                "koen bertels",
                "uri m. ascher",
                "marco bernardo",
                "aaron brown"
        }, 40, timeGenerationSheet);
*/
        calculateMySQLDBTime(new String[]{
                /*   "jeremy n. bailenson",
               "david bainbridge",
               "bonnie berger",*/
                /*     "clare boothe",
               "john blitzer"*/
        }, 20, timeGenerationSheet);

        calculateMySQLDBTime(new String[]{
                /*    "torben g. andersen",*/
                /* "matthias buck",
               "yossi azar",*/
                /*      "shai avidan",
               "jim blythe",*/
                /*  "aude billard",*/
                "elisa bertino"
        }, 3, timeGenerationSheet);

        writer.write();
    }

    private void calculateMySQLDBTime(String[] names, int countIteration, Sheet timeGenerationSheet) {
        for (String name : names) {
            long sumTime = 0;
            SearchGraph sGraph;

            for (int i = 0; i < countIteration; i++) {
                try {
                    sGraph = new SearchGraph(name, EnumSearch.SearchAuthor);
                    sumTime += sGraph.getDbWorkTime();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            timeGenerationSheet.addTimeGeneration("0", name, 0, 0, sumTime / countIteration);
            System.out.println("done: " + name + " " + sumTime / countIteration);
        }
    }

    public void timeMongoDBWork() {
        XLSWriter writer = new XLSWriter("TimeSQLDBWork6.xls");
        Sheet timeGenerationSheet = writer.creteGraphDataSheet();

        calculateMongoDBTime(new String[]{
                "aude billard",
                "elisa bertino"
        }, 2, timeGenerationSheet);
    }

    private void calculateMongoDBTime(String[] names, int countIteration, Sheet timeGenerationSheet) {
        for (String name : names) {
            long sumTime = 0;
            GraphFromMongoDB sGraph;

            for (int i = 0; i < countIteration; i++) {
                try {
                    sGraph = new GraphFromMongoDB(name);
                    sumTime += sGraph.createGraph();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            timeGenerationSheet.addTimeGeneration("0", name, 0, 0, sumTime / countIteration);
            System.out.println("done: " + name + " " + sumTime / countIteration);
        }
    }

    public void generateCliquesTime(int first, int last, int iteration) throws Exception {
        for (int i = first; i < last; i++) {
            String name = names[i];
            long sumTime = 0;
            GraphFromGraphDB graph = new GraphFromGraphDB(name);
            for (int j = 0; j < iteration; j++) {
                sumTime += graph.generateCliquesTime();
            }
            System.out.println(name + " : " + sumTime / iteration);
        }
    }
}
