package GraphTesting;

import org.apache.poi.hssf.usermodel.*;

import java.util.HashMap;

/**
 * Created with IntelliJ IDEA.
 * User: nikita
 * Date: 22.03.13
 * Time: 15:45
 * To change this template use File | Settings | File Templates.
 */
public class Sheet {
    private HSSFWorkbook workbook;
    private HSSFSheet sheet;
    private int currentRow = 0;

    public Sheet(HSSFWorkbook workbook, String sheetName) {
        this.workbook = workbook;
        sheet = workbook.createSheet(sheetName);

        HSSFRow row = sheet.createRow(currentRow);
        row.createCell(0).setCellValue("author_id");
        row.createCell(1).setCellValue("author_name");
        row.createCell(2).setCellValue("count of nodes");
        row.createCell(3).setCellValue("count of relations");
    }

    public void addGraphData(String authorID, String authorName, Integer countOfNodes, Integer countOfRelation) {
        currentRow++;
        HSSFRow row = sheet.createRow(currentRow);
        HSSFCell cellA = row.createCell(0);
        HSSFCell cellB = row.createCell(1);
        HSSFCell cellC = row.createCell(2);
        HSSFCell cellD = row.createCell(3);

        cellA.setCellValue(new HSSFRichTextString(authorID));
        cellB.setCellValue(new HSSFRichTextString(authorName));
        cellC.setCellValue(countOfNodes);
        cellD.setCellValue(countOfRelation);
    }

    public HSSFWorkbook getWorkbook() {
        return workbook;
    }

    public HSSFSheet getSheet() {
        return sheet;
    }

    public int getCurrentRow() {
        return currentRow;
    }

    public void addTimeGeneration(String authorID, String authorName, Integer countOfNodes, Integer countOfRelation, double time) {
        addGraphData(authorID, authorName, countOfNodes, countOfRelation);
        HSSFRow row = sheet.getRow(currentRow);
        row.createCell(4).setCellValue(time);
    }
}
