﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using BEG.Core;
using BEG.Model.Classifiers;
using BEG.Core.Interface;
using BEG.Model.Projections;
using GalaSoft.MvvmLight.Command;
using System.Windows.Input;
using Microsoft.Office.Interop.Visio;
using System.IO;
using System.Windows.Forms;
using Visio = Microsoft.Office.Interop.Visio;

namespace Translytor
{
    public  class Trans: IModule
    {
        public ExtensionContext extensionContext;
        public static string NameClass = "Новый классификатор";
        public string Name { get { return "Тестовый модуль"; } }
        const string CUST_PROP_PREFIX = "Prop.Row_";
        public string PropName;
        public Microsoft.Office.Interop.Visio.Cell PageCell;
        public Microsoft.Office.Interop.Visio.Cell ShapeCell;
        public Microsoft.Office.Interop.Visio.Cell ShapeCell3;
        public void Initialilize(ExtensionContext context)
        {
            extensionContext = context; 
            var group = extensionContext.MenuExtensionPoint.AddRibbonPageGroup("Report", "Генерация из файла Visio");
            
            var testCommand = new RelayCommand(OnOpenGeneratorFormExecuted);
            var testCommand2 = new RelayCommand(OnUpdate);
            
            var testMenuItem = extensionContext.MenuExtensionPoint.AddMenuItem("smReport","Генерация из файла", "aTestMenuItem",
                null, "", testCommand, null, null);
            var testMenuItem2 = extensionContext.MenuExtensionPoint.AddMenuItem("smReport", "Обновление модели", "bTestMenuItem",
              null, "", testCommand2, null, null);
           
            extensionContext.MenuExtensionPoint.AddRibbonItem(group, testMenuItem);
            extensionContext.MenuExtensionPoint.AddRibbonItem(group, testMenuItem2);
        }

        /// <summary>
        /// При нажатии на созданный пункт меню данная функция будет исполнена.
        /// </summary>
       
       public  void OnOpenGeneratorFormExecuted()
        {
            var currentProject = extensionContext.GlobalState.CurrentProject;
            Microsoft.Office.Interop.Visio.Document ActiveDocument;
            Microsoft.Office.Interop.Visio.Cell ShapeCell2;
            var app = new Microsoft.Office.Interop.Visio.Application();
            OpenFileDialog FileDialog = new OpenFileDialog();
            FileDialog.ShowDialog();
            ActiveDocument = app.Documents.Open(FileDialog.FileName);
            Visio.Pages ActivePage = app.ActiveDocument.Pages;
           //идем по всем страницам 
           // int temp = ActiveDocument.Pages.Count;
            for (int i = 1; i <= ActiveDocument.Pages.Count; i++)
            {
                PageCell = ActivePage[i].PageSheet.get_Cells("User.stencilName");
                if (PageCell.get_ResultStr(Microsoft.Office.Interop.Visio.VisUnitCodes.visPageUnits) == "PodoblastDesigner")
                {
                    Visio.Shapes ShapeOnPage = ActivePage[i].Shapes;
                    //идем по всем шейпам на странице
                    for (int j = 1; j <= ShapeOnPage.Count; j++)
                    {
                        string tempResult;
                        Visio.Shape CurrentShape = ShapeOnPage[j];
                        string TempStringName = ShapeOnPage[j].Name;
                        int DotPosition = TempStringName.IndexOf(".", 1);
                        if (DotPosition > 0)
                        {
                            tempResult = TempStringName.Substring(0, DotPosition);
                        }
                        else
                        {
                            tempResult = ShapeOnPage[j].Name;
                        }
                        // создаем все класссификаторы
                        if (tempResult == "Подобласть")
                        {
                                var findResult = currentProject.Classifiers.FirstOrDefault(c => c.Name == CurrentShape.Text);
                                if (findResult == null)
                                {
                                    var newClassifier = new Classifier { Name = CurrentShape.Text };
                                    currentProject.Classifiers.Add(newClassifier);
                                }
                                // тут нужно будет приписать тип класссификатора(подобласть), Никита ещене скинул функцию
                                //тут приписыывается уникальное поле
                                if (CurrentShape.get_CellExists("Prop.Uniq_ID", (short)Microsoft.Office.Interop.Visio.VisExistsFlags.visExistsAnywhere) == 0)
                                {
                                    CurrentShape.AddNamedRow((short)(Microsoft.Office.Interop.Visio.VisSectionIndices.visSectionProp), "Uniq_ID", (short)(Microsoft.Office.Interop.Visio.VisRowIndices.visRowProp));
                                    ShapeCell = CurrentShape.get_CellsU("Prop.Uniq_ID");
                                    ShapeCell.FormulaU = CurrentShape.Text;
                                }
                        }
                        if (tempResult == "Классификатор")
                        {
                            var findResult = currentProject.Classifiers.FirstOrDefault(c => c.Name == CurrentShape.Shapes[6].Text);
                            if (findResult == null)
                            {
                                CreateClassif(CurrentShape); 
                            }
                            
                        }
                        if (tempResult == "Раздел")
                        {
                            var findResult = currentProject.Classifiers.FirstOrDefault(c => c.Name == CurrentShape.Shapes[5].Text);
                            if (findResult == null)
                            {
                                CreateRazdel(CurrentShape);
                            }
                        }
                    }
                }
                //ActivePage[i].PageSheet.AddNamedRow((short)(Microsoft.Office.Interop.Visio.VisSectionIndices.visSectionProp), "Uniq_ID", (short)(Microsoft.Office.Interop.Visio.VisRowIndices.visRowProp));
                //PageCell = ActivePage[i].PageSheet.get_CellsU("Uniq_ID");
                //PageCell.FormulaU = ActivePage[i].Name;
            }

            for (int i = 1; i <= ActiveDocument.Pages.Count; i++)
            {
                PageCell = ActivePage[i].PageSheet.get_Cells("User.stencilName");
                if (PageCell.get_ResultStr(Microsoft.Office.Interop.Visio.VisUnitCodes.visPageUnits) == "PodoblastDesigner")
                {
                    Visio.Shapes ShapeOnPage = ActivePage[i].Shapes;
                    for (int j = 1; j <= ShapeOnPage.Count; j++)
                    {
                        string tempResult;
                        Visio.Shape CurrentShape = ShapeOnPage[j];
                        string TempStringName = ShapeOnPage[j].Name;
                        int DotPosition = TempStringName.IndexOf(".", 1);
                        if (DotPosition > 0)
                        {
                            tempResult = TempStringName.Substring(0, DotPosition);
                        }
                        else
                        {
                            tempResult = ShapeOnPage[j].Name;
                        }
                        if ((tempResult == "Связь с областью\\подобластью") || (tempResult == "Включения") || (tempResult == "Бинарная проекция") || (tempResult == "Проекция") || (tempResult == "Проекции"))
                        {
                            ShapeCell = CurrentShape.get_Cells("User.Start");
                            ShapeCell2 = CurrentShape.get_Cells("User.End");
                            var newProjection = new Projection { Name = ShapeCell.FormulaU + "_" + ShapeCell2.FormulaU };
                            var RightClassif = currentProject.Classifiers.FirstOrDefault(c => c.Name == ShapeCell.get_ResultStr(Microsoft.Office.Interop.Visio.VisUnitCodes.visPageUnits));
                            var LeftClassif = currentProject.Classifiers.FirstOrDefault(c => c.Name == ShapeCell2.get_ResultStr(Microsoft.Office.Interop.Visio.VisUnitCodes.visPageUnits));
                            if ((LeftClassif == null) || (RightClassif == null))
                            {

                            }
                            else
                            {
                            newProjection.LeftRef.Classifier = LeftClassif;
                            newProjection.RightRef.Classifier = RightClassif;

                            currentProject.Projections.Add(newProjection);
                            }
                            if (CurrentShape.get_CellExists("Prop.Uniq_ID", (short)Microsoft.Office.Interop.Visio.VisExistsFlags.visExistsAnywhere) == 0)
                            {
                                CurrentShape.AddNamedRow((short)(Microsoft.Office.Interop.Visio.VisSectionIndices.visSectionProp), "Uniq_ID", (short)(Microsoft.Office.Interop.Visio.VisRowIndices.visRowProp));
                                ShapeCell = CurrentShape.get_CellsU("Prop.Uniq_ID");
                                int x = currentProject.Projections.Count;
                                ShapeCell.FormulaU = Convert.ToString(x);
                            }
                        }
                    }
                }

            }

            ActiveDocument.Save();
            app.Quit(); 
       }
       public void OnUpdate()
       {
            var currentProject = extensionContext.GlobalState.CurrentProject;
            Microsoft.Office.Interop.Visio.Document ActiveDocument;
            Microsoft.Office.Interop.Visio.Cell ShapeCell2;
            Microsoft.Office.Interop.Visio.Cell CurrentShapeCell;
            var app = new Microsoft.Office.Interop.Visio.Application();
            OpenFileDialog FileDialog = new OpenFileDialog();
            FileDialog.ShowDialog();
            ActiveDocument = app.Documents.Open(FileDialog.FileName);
            Visio.Pages ActivePage = app.ActiveDocument.Pages;
           //идем по всем страницам 
           // int temp = ActiveDocument.Pages.Count;
            for (int i = 1; i <= ActiveDocument.Pages.Count; i++)
            {
                PageCell = ActivePage[i].PageSheet.get_Cells("User.stencilName");
                if (PageCell.get_ResultStr(Microsoft.Office.Interop.Visio.VisUnitCodes.visPageUnits) == "PodoblastDesigner")
                {
                    Visio.Shapes ShapeOnPage = ActivePage[i].Shapes;
                    //идем по всем шейпам на странице
                    for (int j = 1; j <= ShapeOnPage.Count; j++)
                    {
                        string tempResult;
                        Visio.Shape CurrentShape = ShapeOnPage[j];
                        //!= значит это поле есть и нужно проверить соответствие , иначе просто создавать новый
                        if (CurrentShape.get_CellExists("Prop.Uniq_ID", (short)Microsoft.Office.Interop.Visio.VisExistsFlags.visExistsAnywhere) != 0)
                        {
                            string TempStringName = ShapeOnPage[j].Name;
                            int DotPosition = TempStringName.IndexOf(".", 1);
                            if (DotPosition > 0)
                            {
                                tempResult = TempStringName.Substring(0, DotPosition);
                            }
                            else
                            {
                                tempResult = ShapeOnPage[j].Name;
                            }
                            // проверяем класссификаторы
                            if (tempResult == "Классификатор")
                            {
                                ShapeCell = CurrentShape.get_Cells("Prop.Uniq_ID");
                                // ID классификатора
                                int ID_Class = Convert.ToInt32(ShapeCell.FormulaU) - 1;
                                int x = currentProject.Classifiers.Count;
                                // смотрим соответствие названия классификатора
                                if (CurrentShape.Shapes[6].Text != currentProject.Classifiers[ID_Class].Name)
                                {
                                    currentProject.Classifiers[ID_Class].Name = CurrentShape.Shapes[6].Text;
                                }
                                // смотрим соответствие атрибутов классификатора
                                for (int a = 1; a < 21; a++)
                                {
                                    PropName = CUST_PROP_PREFIX + a;
                                    CurrentShapeCell = CurrentShape.Shapes[3].get_Cells(PropName);
                                    ShapeCell2 = CurrentShape.Shapes[3].get_CellsSRC(
                                        (short)Microsoft.Office.Interop.Visio.
                                        VisSectionIndices.visSectionProp, (short)(a - 1),
                                        (short)Microsoft.Office.Interop.Visio.
                                        VisCellIndices.visCustPropsLabel);
                                    //значит что то есть
                                    if (CurrentShapeCell.FormulaU != "0")
                                    {
                                        //значит есть уникальное поле
                                        if (ShapeCell2.FormulaU != "\"\"")
                                        {
                                            //MessageBox.Show(currentProject.Classifiers[ID_Class].Items[Convert.ToInt32(ShapeCell2.FormulaU)].Name);
                                            if (currentProject.Classifiers[ID_Class].Items[Convert.ToInt32(ShapeCell2.FormulaU)-1].Name != CurrentShapeCell.FormulaU)
                                            {
                                                currentProject.Classifiers[ID_Class].Items[Convert.ToInt32(ShapeCell2.FormulaU)-1].Name = CurrentShapeCell.FormulaU;
                                            }
                                        }
                                        else
                                        {
                                            var newItem1 = new ClassifierItem { Name = CurrentShapeCell.FormulaU };
                                            currentProject.Classifiers[ID_Class].Add(newItem1);
                                            ShapeCell2.FormulaU = Convert.ToString(currentProject.Classifiers[ID_Class].Items.Count);
                                        }
                                    }
                                }
                                // смотрим соответствие разделов классификатора
                                for (int a = 1; a < 21; a++)
                                {
                                    PropName = CUST_PROP_PREFIX + a;
                                    CurrentShapeCell = CurrentShape.Shapes[4].get_Cells(PropName);
                                    ShapeCell2 = CurrentShape.Shapes[4].get_CellsSRC(
                                        (short)Microsoft.Office.Interop.Visio.
                                        VisSectionIndices.visSectionProp, (short)(a - 1),
                                        (short)Microsoft.Office.Interop.Visio.
                                        VisCellIndices.visCustPropsLabel);
                                    //значит что то есть
                                    if (CurrentShapeCell.FormulaU != "0")
                                    {
                                        string temp = Convert.ToString(ShapeCell2.FormulaU);
                                        //значит есть уникальное поле
                                        if (temp != "\"\"")
                                        {
                                            MessageBox.Show(currentProject.Classifiers[ID_Class].Items[Convert.ToInt32(ShapeCell2.FormulaU)-1].Name);
                                            if (currentProject.Classifiers[ID_Class].Items[Convert.ToInt32(ShapeCell2.FormulaU)-1].Name != CurrentShapeCell.FormulaU)
                                            {
                                                currentProject.Classifiers[ID_Class].Items[Convert.ToInt32(ShapeCell2.FormulaU)-1].Name = CurrentShapeCell.FormulaU;
                                            }
                                        }
                                        else
                                        {
                                            var newItem1 = new ClassifierItem { Name = CurrentShapeCell.FormulaU };
                                            currentProject.Classifiers[ID_Class].Add(newItem1);
                                            newItem1.IsDivision = true;
                                            ShapeCell2.FormulaU = Convert.ToString(currentProject.Classifiers[ID_Class].Items.Count);
                                        }
                                    }
                                }
                            }
                            if (tempResult == "Раздел")
                            {
                                ShapeCell = CurrentShape.get_Cells("Prop.Uniq_ID");
                                // ID классификатора
                                int ID_Class = Convert.ToInt32(ShapeCell.FormulaU) - 1;
                                int x = currentProject.Classifiers.Count;
                                // смотрим соответствие названия раздела
                                if (CurrentShape.Shapes[5].Text != currentProject.Classifiers[ID_Class].Name)
                                {
                                    currentProject.Classifiers[ID_Class].Name = CurrentShape.Shapes[5].Text;
                                }
                                // смотрим соответствие разделов раздела
                                for (int a = 1; a < 21; a++)
                                {
                                    PropName = CUST_PROP_PREFIX + a;
                                    CurrentShapeCell = CurrentShape.Shapes[3].get_Cells(PropName);
                                    ShapeCell2 = CurrentShape.Shapes[3].get_CellsSRC(
                                        (short)Microsoft.Office.Interop.Visio.
                                        VisSectionIndices.visSectionProp, (short)(a - 1),
                                        (short)Microsoft.Office.Interop.Visio.
                                        VisCellIndices.visCustPropsLabel);
                                    //значит что то есть
                                    if (CurrentShapeCell.FormulaU != "0")
                                    {
                                        //значит есть уникальное поле
                                        if (ShapeCell2.FormulaU != "\"\"")
                                        {
                                            if (currentProject.Classifiers[ID_Class].Items[Convert.ToInt32(ShapeCell2.FormulaU)-1].Name != CurrentShapeCell.FormulaU)
                                            {
                                                currentProject.Classifiers[ID_Class].Items[Convert.ToInt32(ShapeCell2.FormulaU)-1].Name = CurrentShapeCell.FormulaU;
                                            }
                                        }
                                        else
                                        {
                                            var newItem1 = new ClassifierItem { Name = CurrentShapeCell.FormulaU };
                                            currentProject.Classifiers[ID_Class].Add(newItem1);
                                            ShapeCell2.FormulaU = Convert.ToString(currentProject.Classifiers[ID_Class].Items.Count);
                                        }
                                    }
                                }
                            }
                            if (tempResult == "Подобласть")
                            {
                                ShapeCell = CurrentShape.get_Cells("Prop.Uniq_ID");
                                // ID классификатора
                                int ID_Class = Convert.ToInt32(ShapeCell.FormulaU) - 1;
                                if (CurrentShape.Text != currentProject.Classifiers[ID_Class].Name)
                                {
                                    currentProject.Classifiers[ID_Class].Name = CurrentShape.Text;
                                }
                            }
                        }
                        else
                        {
                            string TempStringName = ShapeOnPage[j].Name;
                            int DotPosition = TempStringName.IndexOf(".", 1);
                            if (DotPosition > 0)
                            {
                                tempResult = TempStringName.Substring(0, DotPosition);
                            }
                            else
                            {
                                tempResult = ShapeOnPage[j].Name;
                            }
                            // проверяем класссификаторы
                            if (tempResult == "Подобласть")
                            {
                                var findResult = currentProject.Classifiers.FirstOrDefault(c => c.Name == CurrentShape.Text);
                                if (findResult == null)
                                {
                                    var newClassifier = new Classifier { Name = CurrentShape.Text };
                                    currentProject.Classifiers.Add(newClassifier);
                                }
                                // тут нужно будет приписать тип класссификатора(подобласть), Никита еще не скинул функцию
                                //тут приписыывается уникальное поле
                                CurrentShape.AddNamedRow((short)(Microsoft.Office.Interop.Visio.VisSectionIndices.visSectionProp), "Uniq_ID", (short)(Microsoft.Office.Interop.Visio.VisRowIndices.visRowProp));
                                ShapeCell = CurrentShape.get_CellsU("Prop.Uniq_ID");
                                ShapeCell.FormulaU = CurrentShape.Text;
                            }
                            if (tempResult == "Классификатор")
                            {
                                var findResult = currentProject.Classifiers.FirstOrDefault(c => c.Name == CurrentShape.Shapes[6].Text);
                                if (findResult == null)
                                {
                                    CreateClassif(CurrentShape);
                                }

                            }
                            if (tempResult == "Раздел")
                            {
                                var findResult = currentProject.Classifiers.FirstOrDefault(c => c.Name == CurrentShape.Shapes[5].Text);
                                if (findResult == null)
                                {
                                    CreateRazdel(CurrentShape);
                                }
                            }
                        }
                    }
                }
            }
            ActiveDocument.Save();
            app.Quit(); 
       }
       public void CreateClassif(Visio.Shape CurrentShape)
       {
           Microsoft.Office.Interop.Visio.Cell CurrentShapeCell;
           var currentProject = extensionContext.GlobalState.CurrentProject;
           var newClassifier = new Classifier { Name = CurrentShape.Shapes[6].Text };
           currentProject.Classifiers.Add(newClassifier);
                            // тут вставляем тип классификатора
                            //приписываение уникального поля
           if (CurrentShape.get_CellExists("Prop.Uniq_ID", (short)Microsoft.Office.Interop.Visio.VisExistsFlags.visExistsAnywhere) == 0)
           {
               CurrentShape.AddNamedRow((short)(Microsoft.Office.Interop.Visio.VisSectionIndices.visSectionProp), "Uniq_ID", (short)(Microsoft.Office.Interop.Visio.VisRowIndices.visRowProp));
               CurrentShapeCell = CurrentShape.get_CellsU("Prop.Uniq_ID");
               int x = currentProject.Classifiers.Count;
               CurrentShapeCell.FormulaU = Convert.ToString(x);
           }
                            
                    
           //тут записываем все атрибуты    
           for (int a = 1; a < 21; a++)
           {
                PropName = CUST_PROP_PREFIX + a;
                CurrentShapeCell = CurrentShape.Shapes[3].get_Cells(PropName); 
                ShapeCell = CurrentShape.Shapes[3].get_CellsSRC(
                (short)Microsoft.Office.Interop.Visio.
                    VisSectionIndices.visSectionProp, (short)(a - 1),
                (short)Microsoft.Office.Interop.Visio.
                    VisCellIndices.visCustPropsLabel);
                if (CurrentShapeCell.FormulaU != "0")
                {
                    var newItem1 = new ClassifierItem { Name = CurrentShapeCell.FormulaU };
                    newClassifier.Add(newItem1);
                    ShapeCell.FormulaU = Convert.ToString(newClassifier.Items.Count);
                }

           }
           //тут записываем разделы
           for (int a = 1; a < 21; a++)
           {
               ShapeCell3 = CurrentShape.Shapes[4].get_CellsSRC(
                (short)Microsoft.Office.Interop.Visio.
                    VisSectionIndices.visSectionProp, (short)(a - 1),
                (short)Microsoft.Office.Interop.Visio.
                    VisCellIndices.visCustPropsLabel);
                PropName = CUST_PROP_PREFIX + a;
                CurrentShapeCell = CurrentShape.Shapes[4].get_Cells(PropName);
                if (CurrentShapeCell.FormulaU != "0")
                {
                    var newItem1 = new ClassifierItem { Name = CurrentShapeCell.FormulaU };
                    newClassifier.Add(newItem1);
                    newItem1.IsDivision = true;
                    ShapeCell3.FormulaU = Convert.ToString(newClassifier.Items.Count);
                }

           }
       }
        public void CreateRazdel(Visio.Shape CurrentShape)
        {
            var currentProject = extensionContext.GlobalState.CurrentProject;
            var newClassifier = new Classifier { Name = CurrentShape.Shapes[5].Text };
            currentProject.Classifiers.Add(newClassifier);
             // тут вставляем тип классификатора
             //приписываение уникального поля
            if (CurrentShape.get_CellExists("Prop.Uniq_ID", (short)Microsoft.Office.Interop.Visio.VisExistsFlags.visExistsAnywhere) == 0)
            {
                CurrentShape.AddNamedRow((short)(Microsoft.Office.Interop.Visio.VisSectionIndices.visSectionProp), "Uniq_ID", (short)(Microsoft.Office.Interop.Visio.VisRowIndices.visRowProp));
                ShapeCell = CurrentShape.get_CellsU("Prop.Uniq_ID");
                ShapeCell.FormulaU = CurrentShape.Shapes[5].Text;
            }
            for (int a = 1; a < 21; a++)
            {
                ShapeCell3 = CurrentShape.Shapes[3].get_CellsSRC(
                (short)Microsoft.Office.Interop.Visio.
                    VisSectionIndices.visSectionProp, (short)(a - 1),
                (short)Microsoft.Office.Interop.Visio.
                    VisCellIndices.visCustPropsLabel);
                PropName = CUST_PROP_PREFIX + a;
                ShapeCell = CurrentShape.Shapes[3].get_Cells(PropName);
                if (ShapeCell.FormulaU != "0")
                {
                    var newItem1 = new ClassifierItem { Name = ShapeCell.FormulaU };
                    newClassifier.Add(newItem1);
                    ShapeCell3.FormulaU = Convert.ToString(newClassifier.Items.Count);
                 }

            }
        }

            // Создания двух позиций классификатора
           /* var newItem1 = new ClassifierItem { Name = "Новый элемент 1" };
            var newItem2 = new ClassifierItem { Name = "Новый элемент 2" };
            newClassifier.Add(newItem1);
            newClassifier.Add(newItem2);

            // Новая проекция Левая и Правая размерность задаются классификатором newClassifier
            var newProjection = new Projection { Name = "Новая проекция" };
            newProjection.LeftRef.Classifier = newClassifier;
            newProjection.RightRef.Classifier = newClassifier;
            currentProject.Projections.Add(newProjection);

            // Создание связей между проекциями лучше делать через специальный метод CreateLink
            var references = new Dictionary<ReferenceDescription, ClassifierItem>
                {
                    {newProjection.LeftRef, newItem1},
                    {newProjection.RightRef, newItem2}
                };
            var newLink = newProjection.CreateLink(references);

            // Теперь в модели будут один новый классификатор и проекция.
            */
        

        public void OnClosing()
        {
        }
    }
}
