﻿//Created by TveMA, 2012
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;


namespace TveMA.FStorage
{
    public partial class Classify : Form
    {
        Classifier.Classifier classifier;
        public Classify()
        {
            InitializeComponent();
            classifier = new Classifier.Classifier();
            classifier.RebuildProbTables();
        }

        private void openFileDialog1_FileOk(object sender, CancelEventArgs e)
        {

        }

        private void label1_Click(object sender, EventArgs e)
        {

        }

        private void button1_Click(object sender, EventArgs e)
        {
            probtags.Text = "";
            string text = "";
            classifyOne(classifier, ref text, listOfTags.Text);
            probtags.Text = text;
            probtags.Refresh();

        }

        private void classifyOne(Classifier.Classifier classifier, ref string text, string listOfTags)
        {
            if (listOfTags != "")
            {
                Dictionary<string, double> prob = new Dictionary<string, double>();
                List<string> tags = new List<string>(listOfTags.Split(new Char[] { ',' }));
                for (int i = 0; i < tags.Count; i++)
                    tags[i] = tags[i].Trim();
                prob = classifier.FindPosTagsOfFile(tags);
                string sortedtext ="";
                string buff;
                KeyValuePair<string, double> buffValue;
                for (int i = 0; i < 5; i++)
                {
                    buffValue = new KeyValuePair<string, double>("1", -1);
                    foreach (KeyValuePair<string, double> pair in prob)
                    {
                        if (buffValue.Value < pair.Value)
                            buffValue = new KeyValuePair<string,double>(pair.Key,pair.Value);
                    }
                    buff = buffValue.Value.ToString();
                    sortedtext += buffValue.Key + " = " + buff.Substring(0,8) + " | ";
                    prob.Remove(buffValue.Key);
                }
                sortedtext.Remove(sortedtext.Length - 2);
                text += sortedtext + "\n ";
            }
        }

        private void button1_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == (char)Keys.Enter)
                button1_Click(sender, e);
        }

        private void b_test_Click(object sender, EventArgs e)
        {
            string text = "";
            openFileDialog1.ShowDialog();
            List<string> inputs= new List<string>();
            using (StreamReader reader = new StreamReader(this.openFileDialog1.OpenFile(),Encoding.GetEncoding(1251)))           
            {
                while (!reader.EndOfStream)
                {
                    inputs.Add(reader.ReadLine());
                }
            }
            openFileDialog1.Reset();
            foreach (string input in inputs)
            {
                text += input + " | ";
                classifyOne(classifier, ref text, input);
            }
            using (StreamWriter writer = new StreamWriter("testDone.txt"))
            {
                string[] lines = text.Split(new char[] { '\n' });
                for (int i = 0; i < lines.Length; i++)
                    writer.WriteLine(lines[i]);
            }
            probtags.Text = "DONE!";
            probtags.Refresh();
        }

        private void Classify_Load(object sender, EventArgs e)
        {

        }


    }
}
