﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Data;
using Dokan;
using TveMA.FStorage.Core;

namespace VFS
{
    class VFS : DokanOperations
    {

        public int CreateFile(string filename, FileAccess access, FileShare share,
            FileMode mode, FileOptions options, DokanFileInfo info)
        {
            switch (mode)
            {
                // Opens the file if it exists and seeks to the end of the file, 
                // or creates a new file
                case FileMode.Append:
                    return 0;

                // Specifies that the operating system should create a new file. 
                // If the file already exists, it will be overwritten. 
                case FileMode.Create:

                    return 0;

                // Specifies that the operating system should create a new file. 
                // If the file already exists, an IOException is thrown.
                case FileMode.CreateNew:

                    return 0;

                // Specifies that the operating system should open an existing file. 
                // A System.IO.FileNotFoundException is thrown if the file does not exist.
                case FileMode.Open:
                        return 0;

                // Specifies that the operating system should open a file if it exists; 
                // otherwise, a new file should be created.
                case FileMode.OpenOrCreate:
                    return 0;

                // Specifies that the operating system should open an existing file. 
                // Once opened, the file should be truncated so that its size is zero bytes
                case FileMode.Truncate:
                    return 0;

            }
            return 0;
        }


        public int OpenDirectory( string filename, DokanFileInfo info)
        {
            return 0;
        }
     

        public int CreateDirectory( string filename, DokanFileInfo info)
        {
            return -1;
        }

        public int Cleanup( string filename, DokanFileInfo info)
        {
            return 0;
        }

        public int CloseFile( string filename, DokanFileInfo info)
        {
            return 0;
        }

        public int ReadFile( string filename, byte[] buffer, ref uint readBytes,
                long offset, DokanFileInfo info)
        {
            try
            {

                string[] path = Utility.Split(filename,"\\");
                string name = path[path.Length-1];
                Array.Resize(ref path,path.Length-1);
                CoreFSt core = new CoreFSt();
                string[] fullname = name.Split(new Char[] { '.' });
                DataTable files = new DataTable();
                files = core.search(fullname[0], (fullname.Length == 2) ? "."+fullname[1] : "", "", string.Join(", ",path), "");

                if (files != null && files.Rows.Count != 0)
                {
                    DataRow neededFile = Utility.findFile(path, files);
                    readBytes = core.readFile(new Guid(neededFile[0].ToString()), buffer, offset);
                    Console.Error.WriteLine("Readed :{2} : {1} --- {0}" , readBytes, offset,filename);
                }
                
                return 0;
            }
            catch (Exception)
            {
                return -1;
            }
        }


        public int WriteFile( string filename, byte[] buffer, ref uint writtenBytes,
                long offset, DokanFileInfo info)
        {
            //
            return -1;
        }

        public int FlushFileBuffers(string filename, DokanFileInfo info)
        {
            //
            return -1;
        }



        public int GetFileInformation(string filename, FileInformation fInfo, DokanFileInfo info)
        {
            if (filename == "\\")
            {
                fInfo.Attributes = System.IO.FileAttributes.Directory;
                fInfo.LastAccessTime = DateTime.Now;
                fInfo.LastWriteTime = DateTime.Now;
                fInfo.CreationTime = DateTime.Now;

                return 0;
            }
            else
            {
                //by name fill information fileinfo 
                string[] path = Utility.Split(filename,"\\");
                string name = path[path.Length-1];
                Array.Resize(ref path,path.Length-1);
                CoreFSt core = new CoreFSt();
                string[] fullname = name.Split(new Char[] { '.' });
                DataTable files = new DataTable();
                files = core.search(fullname[0], (fullname.Length == 2) ? "."+fullname[1] : "", "", string.Join(", ",path), "GET_SIZE");
                DataRow file;
                if (files != null && files.Rows.Count != 0)
                {
                    file = files.Rows[0];

                    fInfo.Attributes = System.IO.FileAttributes.Normal;
                    fInfo.CreationTime = file.Field<DateTime?>(5).GetValueOrDefault(DateTime.Now);
                    fInfo.LastAccessTime = file.Field<DateTime?>(6).GetValueOrDefault(DateTime.Now);
                    fInfo.LastWriteTime = file.Field<DateTime?>(6).GetValueOrDefault(DateTime.Now);
                    fInfo.Length = file.Field<long?>(7).GetValueOrDefault(0);
                    return 0;
                }
                else
                {
                    files = core.getTags(new List<string>() { name });
                    if (files != null && files.Rows.Count != 0)
                    {
                        fInfo.Attributes = System.IO.FileAttributes.Directory;
                        fInfo.LastAccessTime = DateTime.Now;
                        fInfo.LastWriteTime = DateTime.Now;
                        fInfo.CreationTime = DateTime.Now;
                        fInfo.Length = 0;
                        return 0;
                    }
                }
            }
                return -1;
        }

        public int FindFiles( string filename, System.Collections.ArrayList files, DokanFileInfo info)
        {
            //if filename is root move its files to files
            CoreFSt core = new CoreFSt();

            DataTable gotFiles = new DataTable();
            if (filename == "\\")
            {
                gotFiles = core.getTags();
                foreach (DataRow tag in gotFiles.Rows)
                {
                    FileInformation fInfo = new FileInformation();
                    fInfo.FileName = tag[1].ToString();
                    fInfo.Attributes = System.IO.FileAttributes.Directory;
                    fInfo.LastAccessTime = DateTime.Now;
                    fInfo.LastWriteTime = DateTime.Now;
                    fInfo.CreationTime = DateTime.Now;
                    files.Add(fInfo);
                }
                return 0;
            }
            else
            {
                string[] path = Utility.Split(filename, "\\");
                string name = path[path.Length - 1];
                gotFiles = core.getTags(new List<string>() { name });
                    
                if (gotFiles != null && gotFiles.Rows.Count != 0)
                {
                    if (path.Length>1)
                        gotFiles = core.search("", "", "", string.Join(",", path), "GET_SIZE");
                    else
                        gotFiles = core.search("", "", "", name, "GET_SIZE");

                    if (gotFiles == null && gotFiles.Rows.Count == 0)
                        return 0;
                    List<string> tags= new List<string>();

                    foreach (DataRow file in gotFiles.Rows)
                    {

                        string[] tagOfFile = Utility.Split(file[4].ToString(),",");
                        if (Utility.HaveAllTags(tagOfFile, path))
                        {
                            FileInformation fInfo = new FileInformation();
                            fInfo.FileName = file[2].ToString().Trim() + file[3].ToString().Trim();
                            fInfo.Attributes = System.IO.FileAttributes.Normal;
                            fInfo.CreationTime = file.Field<DateTime?>(5).GetValueOrDefault(DateTime.Now);
                            fInfo.LastAccessTime = file.Field<DateTime?>(6).GetValueOrDefault(DateTime.Now);
                            fInfo.LastWriteTime = file.Field<DateTime?>(6).GetValueOrDefault(DateTime.Now);
                            fInfo.Length = file.Field<long?>(7).GetValueOrDefault(0);
                            files.Add(fInfo);

                            foreach (string tag in tagOfFile)
                            {
                                if (!tags.Contains(tag))
                                    tags.Add(tag);

                            }
                        }
                    }
                    foreach (string tag in path)
                        tags.Remove(tag);

                    foreach (string tag in tags)
                    {
                        FileInformation fInfo = new FileInformation();
                        fInfo.FileName = tag;
                        fInfo.Attributes = System.IO.FileAttributes.Directory;
                        fInfo.LastAccessTime = DateTime.Now;
                        fInfo.LastWriteTime = DateTime.Now;
                        fInfo.CreationTime = DateTime.Now;
                        files.Add(fInfo);
                    }
                    return 0;
                }
            }
            return -1;
        }

        public int SetFileAttributes( string filename, System.IO.FileAttributes attr, DokanFileInfo info)
        {
            //
            return -1;
        }

        public int SetFileTime( string filename, DateTime ctime, DateTime atime, DateTime mtime, DokanFileInfo info)
        {
            return -1;
        }

        public int DeleteFile( string filename, DokanFileInfo info)
        {
            string[] path = Utility.Split(filename, "\\");
            string name = path[path.Length - 1];
            Array.Resize(ref path, path.Length - 1);
            if (path.Length > 0)
            {
                CoreFSt core = new CoreFSt();
                string[] fullname = name.Split(new Char[] { '.' });
                DataTable files = new DataTable();
                files = core.search(fullname[0], (fullname.Length == 2) ? "."+fullname[1] : "", "", string.Join(", ",path), "GET_SIZE");
                if (files != null && files.Rows.Count != 0)
                {
                    DataRow neededFile = Utility.findFile(path, files);
                    string lastTag = path[path.Length - 1];
                    core.update(new Guid(neededFile[0].ToString()), Utility.RemoveTag(neededFile[4].ToString(), lastTag));           
                }
            }
            return 0;
        }



        public int DeleteDirectory(string filename, DokanFileInfo info)
        {
            return -1;
        }

        public int MoveFile( string filename, string newname, bool replace, DokanFileInfo info)
        {
            string[] path1 = Utility.Split(filename, "\\");
            string[] path2 = Utility.Split(newname, "\\");
            string name = path1[path1.Length - 1];
            Array.Resize(ref path1, path1.Length - 1);
            Array.Resize(ref path2, path2.Length - 1);
            if (path1.Length > 0)
            {
                CoreFSt core = new CoreFSt();
                string[] fullname = name.Split(new Char[] { '.' });
                DataTable files = new DataTable();
                files = core.search(fullname[0], (fullname.Length == 2) ? "." + fullname[1] : "", "", string.Join(", ", path1), "GET_SIZE");
                if (files != null && files.Rows.Count != 0)
                {
                    DataRow neededFile = Utility.findFile(path1, files);
                    core.update(new Guid(neededFile[0].ToString()), Utility.RemoveTags(neededFile[4].ToString(), path1) + ((path2.Length>0)?"," +string.Join(", ", path2):""));
                }
            }
            return 0;
        }


        public int SetEndOfFile( string filename, long length, DokanFileInfo info)
        {
            //
            return -1;
        }


        public int SetAllocationSize(  string filename, long length, DokanFileInfo info)
        {
            //
            return -1;
        }


        public int LockFile( string filename, long offset, long length, DokanFileInfo info)
        {
            return 0;
        }

        public int UnlockFile( string filename, long offset, long length, DokanFileInfo info)
        {
            return 0;
        }

        public int GetDiskFreeSpace( ref ulong freeBytesAvailable, ref ulong totalBytes, ref ulong totalFreeBytes, 
            DokanFileInfo info)
        {
            freeBytesAvailable = 512 * 1024 * 1024;
            totalBytes = 1024 * 1024 * 1024;
            totalFreeBytes = 512 * 1024 * 1024;
            return 0;
        }

        public int Unmount( DokanFileInfo info)
        {
            return 0;
        }

    }
}
