﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Drawing;
using System.Drawing.Drawing2D;

namespace VFS
{
    class Utility
    {

        /// Used to retrieve the first available driveletter
        /// </summary>
        /// <returns>A driveletter that's not in use yet</returns>
        internal static char GetFirstAvailableDriveLetter()
        {
            DriveInfo[] usedDrives = DriveInfo.GetDrives();
            List<char> usedDirveLetters = new List<char>();
            foreach (DriveInfo drive in usedDrives)
                usedDirveLetters.Add(drive.Name.ToUpperInvariant()[0]);
            char c = ' ';
            for (c = 'D'; c < 'Z'; c++)
                if (!usedDirveLetters.Contains(c))
                    break;
            if (c == ' ')
                throw new DriveNotFoundException("There is no drives available");
            return c;
        }


        internal static DataRow findFile(string[] path, DataTable files)
        {

            DataRow neededFile = null;
            if (files.Rows.Count > 1)
            {
                foreach (DataRow file in files.Rows)
                {
                    string[] tagOfFile = Utility.Split(file[4].ToString(), ",");
                    if (Utility.HaveAllTags(tagOfFile, path))
                    {
                        neededFile = file;
                        break;
                    }
                }
            }
            else
                neededFile = files.Rows[0];
            return neededFile;
        }

        internal static string RemoveTag(string fileTags,string tagForRemove)
        {
            string[] tags = Split(fileTags, ",");
            string[] tagsResult = new string[tags.Length-1];
            int j=0;
            for (int i = 0; i < tagsResult.Length; i++)
            {
                if (tags[i] == tagForRemove)
                    j = j + 1;
                tagsResult[i] = tags[j];
                j = j + 1;
            }

            return string.Join(", ", tagsResult);
        }

        internal static string RemoveTags(string fileTags, string[] tagsForRemove)
        {
            string[] tags = Split(fileTags, ",");
            string[] tagsResult = new string[tags.Length - tagsForRemove.Length];
            int j = 0;
            for (int i = 0; i < tagsResult.Length; i++)
            {
                while (-1 != Array.IndexOf(tagsForRemove, tags[j]))
                    j = j + 1;

                tagsResult[i] = tags[j];
                j = j + 1;
            }

            return string.Join(", ", tagsResult);
        }

        /// <summary>
        /// This method generates a nice icon for us
        /// </summary>
        /// <param name="c">Some letter to display on the icon</param>
        /// <param name="ballColor">The color of the ball to be drawn</param>
        /// <returns>a new Icon</returns>
        internal static Icon CreateIcon(char c, Color ballColor)
        {
            Font myFont = new Font("Arial Black", 12, FontStyle.Bold, GraphicsUnit.Pixel);
            string letter = c.ToString();
            Bitmap bm = new Bitmap(16, 16);

            Graphics g = Graphics.FromImage((Image)bm);
            g.SmoothingMode = SmoothingMode.AntiAlias;
            Rectangle rect = new Rectangle(0, 0, 15, 15);
            GraphicsPath path = new GraphicsPath();
            path.AddEllipse(rect);

            PathGradientBrush pgbrush = new PathGradientBrush(path);
            pgbrush.CenterPoint = new Point((rect.Right - rect.Left) / 3 + rect.Left, (rect.Bottom - rect.Top) / 3 + rect.Top);
            pgbrush.CenterColor = Color.White;
            pgbrush.SurroundColors = new Color[] { ballColor };

            g.FillEllipse(pgbrush, rect);
            g.DrawEllipse(new Pen(ballColor), rect);

            g.DrawString(letter, myFont, Brushes.Black, new Point(4, 4));
            g.DrawString(letter, myFont, Brushes.White, new Point(5, 3));

            return Icon.FromHandle(bm.GetHicon());
        }

        internal static string[] Split(string name, string separator)
        {
            string[] result = name.Split(new string[] { separator }, StringSplitOptions.RemoveEmptyEntries);
            for (int i=0; i < result.Length; i++)
                result[i] = result[i].Trim();
            return result;
        }
        internal static bool HaveAllTags(string[] tagsOfFile, string[] path)
        {
            foreach (string folder in path)
            {
                if (Array.IndexOf(tagsOfFile,folder)==-1)
                    return false;
            }
            return true;
        }
    }
}
