﻿//Created by TveMA, 2012
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;

namespace TveMA.Classifier
{
    class StatisticStorage
    {
        private static string ConnectAsync
= Connect + Properties.Settings.Default.Async;
        private static string Connect = Properties.Settings.Default.FSConnectionString;

        public static int Store(MatrixDbl simF, MatrixDbl simT, List<Guid> tags, List<Guid> files, int[] occurenceOftags)
        {
            SqlConnection cn = null;
            SqlTransaction tran = null;
            try
            {

                cn = new SqlConnection(Connect);
                cn.Open();
                tran = cn.BeginTransaction("CLTrans");
                SqlCommand cm = cn.CreateCommand();
                cm.Transaction = tran;
                FillRaC(tags, files, cm);
                FillOccurence(occurenceOftags, tags, cm);
                FillMAtrix(simF, files, cm,QTable.SimF);
                FillMAtrix(simT, tags, cm, QTable.SimT);

                tran.Commit();
            }
            catch (SqlException ex)
            {
                tran.Rollback(QString.TransName);
                return -1;
            }
            finally
            {
                if (cn != null)
                {
                    cn.Close();
                }
            }
            return 0;
        }

        public static int GetMatrix(out MatrixDbl simMatrix, out List<Guid> row, bool IsTag)
        {
            SqlConnection cn = null;
            SqlTransaction tran = null;
            try
            {

                cn = new SqlConnection(Connect);
                cn.Open();
                tran = cn.BeginTransaction("CLTrans2");
                SqlCommand cmTable = cn.CreateCommand();
                SqlCommand cmRow = cn.CreateCommand();
                DataTable resTable = new DataTable();
                DataTable resRow = new DataTable();
                cmTable.Transaction = tran;
                cmRow.Transaction = tran;
                if (IsTag)
                {
                    cmTable.CommandText = QString.SELECTAllFr(QTable.SimT);
                    cmRow.CommandText = QString.SELFrWh(QString.Num + "," + QString.Tag, QTable.RaC, QString.Tag + " IS NOT " + QString.Null);
                    resTable = new DataTable(QTable.SimT);
                }
                else
                {
                    cmTable.CommandText = QString.SELFr(QString.SimDataList, QTable.SimF);
                    cmRow.CommandText = QString.SELFrWh(QString.Num + "," + QString.File, QTable.RaC, QString.File +" IS NOT "+QString.Null);
                    resTable = new DataTable(QTable.SimF);
                }
                SqlDataReader reader1 = cmTable.ExecuteReader();
                resTable.Load(reader1);
                SqlDataReader reader2 = cmRow.ExecuteReader();
                resRow.Load(reader2);
                simMatrix = new MatrixDbl(resTable, resRow.Rows.Count);
                row = new List<Guid>(resRow.Rows.Count);
                foreach (DataRow dr in resRow.Rows)
                {
                    row.Add(new Guid(dr[1].ToString()));
                }
                
            }
            catch (SqlException ex)
            {
                simMatrix = new MatrixDbl(0, 0);
                row = new List<Guid>();
                tran.Rollback(QString.TransName);
                return -1;
            }
            finally
            {
                if (cn != null)
                {
                    cn.Close();
                }
            }
            return 0;
        }



        private static void FillMAtrix(MatrixDbl simMatrix, List<Guid> row, SqlCommand cm, string name)
        {
            cm.CommandText = "";
            for (int i = 0; i < row.Count; i++)
                for (int j = 0; j < row.Count; j++)
                {
                    cm.Parameters.Clear();
                    cm.CommandText = QString.INSERT(name, QString.ROW21(i.ToString(), j.ToString(), QParam.Num + i.ToString() + j.ToString()));
                    cm.Parameters.Add(QParam.Num + i.ToString()+ j.ToString(), SqlDbType.Float);
                    cm.Parameters[0].Value = simMatrix.values[i, j];
                    cm.ExecuteReader(CommandBehavior.Default).Close();
                }

        }

        private static void FillOccurence(int[] occur, List<Guid> tags, SqlCommand cm)
        {
            cm.CommandText = "";
            for (int i = 0; i < tags.Count; i++)
                 cm.CommandText = cm.CommandText + QString.INSERT(QTable.UoT, QString.ROW3(tags[i].ToString(), occur[i].ToString()));

            cm.ExecuteReader(CommandBehavior.Default).Close();
        }
        public static int GetOccurence(out Dictionary<Guid,int> occurenceOfTags)
        {
            occurenceOfTags = new Dictionary<Guid, int>();
            SqlConnection cn = null;
            SqlTransaction tran = null;
            try
            {

                cn = new SqlConnection(Connect);
                cn.Open();
                tran = cn.BeginTransaction("CLTrans");
                SqlCommand cm = cn.CreateCommand();
                DataTable resTable = new DataTable();
                cm.Transaction = tran;
                cm.CommandText = QString.SELECTAllFr(QTable.UoT);
                resTable = new DataTable(QTable.UoT);
                SqlDataReader reader = cm.ExecuteReader();
                resTable.Load(reader);
                foreach (DataRow dr in resTable.Rows)
                {
                    occurenceOfTags.Add(new Guid(dr[0].ToString()), Convert.ToInt32(dr[1].ToString()));
                }

            }
            catch (SqlException ex)
            {
                tran.Rollback(QString.TransName);
                return -1;
            }
            finally
            {
                if (cn != null)
                {
                    cn.Close();
                }
            }
            return 0;
        }
        private static void FillRaC(List<Guid> tags, List<Guid> files, SqlCommand cm)
        {
            int i = 0;
            cm.CommandText = QString.INSERT(QTable.RaC, QString.ROW1(i.ToString(), files[0].ToString(), tags[0].ToString()));
            cm.ExecuteReader(CommandBehavior.Default).Close();
            for (i = 1; i < Math.Min(tags.Count, files.Count); i++)
            {
                cm.CommandText = QString.INSERT(QTable.RaC, QString.ROW1(i.ToString(), files[i].ToString(), tags[i].ToString()));
                cm.ExecuteReader(CommandBehavior.Default).Close();
            }
            if (tags.Count > files.Count)
                while (i < tags.Count)
                {
                    i = files.Count;
                    cm.CommandText = QString.INSERT(QTable.RaC, QString.ROW12(i.ToString(),QString.Null, tags[i].ToString()));
                    cm.ExecuteReader(CommandBehavior.Default).Close();
                    i++;
                }
            else if (tags.Count < files.Count)
                while (i < files.Count)
                {
                    cm.CommandText = QString.INSERT(QTable.RaC, QString.ROW11(i.ToString(), files[i].ToString(), QString.Null));
                    cm.ExecuteReader(CommandBehavior.Default).Close();
                    i = i+1;
                }
        }
        public static int ClearStr()
        {
            SqlConnection cn = null;
            SqlTransaction tran = null;
            try
            {
                cn = new SqlConnection(Connect);
                cn.Open();
                tran = cn.BeginTransaction("CLTrans");
                SqlCommand cm = cn.CreateCommand();
                cm.Transaction = tran;
                cm.CommandText = QString.DELETE(QTable.SimF) + " " + QString.DELETE(QTable.SimT)
                   + " " + QString.DELETE(QTable.RaC) + " " + QString.DELETE(QTable.UoT);
                cm.ExecuteReader().Close();
            }
            catch (SqlException ex)
            {
                tran.Rollback(QString.TransName);
                return -1;
            }
            finally
            {
                tran.Commit();
                if (cn != null)
                {
                    cn.Close();
                }
            }
            return 0;
        }
    }
}
