﻿//Created by TveMA, 2012
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;

namespace TveMA.Classifier
{
    class Matrix 
    {
        public int width;
        public int height;

        public Matrix()
        {
            width = 0;
            height = 0;
        }

        public Matrix(int height, int width)
        {
            this.width = width;
            this.height = height;
        }
    }
    class MatrixDbl : Matrix
    {
        public double[,] values;
        public bool matrixIsRight = false;


        public MatrixDbl(int height, int width)
            : base(height, width)
        {
            values = new double[height, width];
        }

        public MatrixDbl(DataTable val, List<Guid> rows, List<Guid> columns, ref int[] occurence)
        {
            height = rows.Count;
            width = columns.Count;
            values = new double[height, width];
            foreach (DataRow dr in val.Rows)
            {
                int rowN = rows.FindIndex(f => f ==(Guid)dr[0]);
                int colN = columns.FindIndex(f => f == (Guid)dr[1]);
                occurence[rowN] += 1;
                values[rowN, colN] = 1;
            }

            matrixIsRight = true;
        }
        public MatrixDbl(DataTable val, int count)
        {
            values = new double[count, count];
            foreach (DataRow dr in val.Rows)
            {
                values[(int)dr[0], (int)dr[1]] = (double)dr[2];
            }
        }
    }
    class MatrixInt : Matrix
    {
        public int[,] values;

        public MatrixInt(int height, int width) : base(height, width)
        {
            values = new int[height, width];
        }
        public MatrixInt(DataTable val, int count)
        {
            values = new int[count, count];
            foreach (DataRow dr in val.Rows)
            {
                values[(int)dr[0], (int)dr[1]] = (int)dr[2];
            }
        }
    }
}
