﻿//Created by TveMA, 2012
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;

namespace TveMA.Classifier.LSA
{
    class LSA
    {
        double step = 0.25;
        MatrixDbl matrixOfFrequencies;
        public List<Guid> files = new List<Guid>();
        public List<Guid> tags = new List<Guid>();
        public int[] OccurenceOfTag;
        public MatrixDbl similarityOfFiles;
        public MatrixDbl similarityOfTags;
        //Dictionary<Guid, String[]> notions;
        //Dictionary<Guid, Guid[]> filesInNotions;

        public LSA()
        {
            FStorage.Core.CoreFSt core = new FStorage.Core.CoreFSt();
            DataTable listfiles = core.getFiles();
            DataTable listtags = core.getTags();
            OccurenceOfTag = new int[listtags.Rows.Count];
            for (int i = 0; i < listfiles.Rows.Count; i++)
            {
                files.Add(new Guid(listfiles.Rows[i][0].ToString()));
            }
            for (int j = 0; j < listtags.Rows.Count; j++)
            {
                tags.Add(new Guid(listtags.Rows[j][0].ToString()));
            }
            matrixOfFrequencies = new MatrixDbl(core.getTagsOfFile(), tags, files, ref OccurenceOfTag);
            similarityOfFiles = new MatrixDbl(listfiles.Rows.Count, listfiles.Rows.Count);
            similarityOfTags = new MatrixDbl(listtags.Rows.Count, listtags.Rows.Count);
        }
        public int Work()
        {
            double[] sigma;
            double[,] u;
            double[,] vt;
            SVD(out sigma, out u, out vt);
            int k = CalcAmountOfBigVal(sigma);
            CalcProbabilitySimilarity(k,sigma, vt, matrixOfFrequencies.width, false, ref similarityOfFiles.values);
            CalcProbabilitySimilarity(k,sigma, u, matrixOfFrequencies.height, true, ref similarityOfTags.values);

            //SetSemanticSpace(k, sigma, u , vt);
            
            StoreResult();

            return files.Count;
        }

        private int CalcAmountOfBigVal(double[] sigma)
        {
            double max = sigma[0];
            int i=0;
            int count = 0;

            while (i < sigma.Length && sigma[i] > max * step)
            {
                i++;
                count++;
            }
            return count;
        }

        private void SetSemanticSpace(int k, double[] sigma, double[,] u, double[,] vt)
        {
            throw new NotImplementedException();
        }

        private void SVD(out double[] sigma, out double[,] u, out double[,] vt)
        {
            int minSize = Math.Min(matrixOfFrequencies.width, matrixOfFrequencies.height);
            sigma = new double[minSize];
            u = new double[matrixOfFrequencies.height, minSize];
            vt = new double[minSize, matrixOfFrequencies.width];

            alglib.rmatrixsvd(matrixOfFrequencies.values, matrixOfFrequencies.height, matrixOfFrequencies.width, 1, 1, 2, out sigma, out u, out vt);
        }

        private void CalcProbabilitySimilarity(int size, double[] sigma, double[,] matrix, int matrixsSide, bool takeRows, ref double[,] outputMatrix)
        {
            double[] v1 = new double[size];
            double[] v2 = new double[size];
            double[] buff1 = new double[size];
            double[] buff2 = new double[size];
            for (int l = 0; l < size; l++)
            {
                v1[l] = sigma[l];
                v2[l] = sigma[l];
            }
            for (int i = 0; i < matrixsSide; i++)
                for (int j = 0; j < matrixsSide && j <= i; j++)
                {
                    for (int k = 0; k < size; k++)
                    {
                        if (takeRows)
                        {
                            buff1[k] = v1[k] * matrix[i, k];
                            buff2[k] = v2[k] * matrix[j, k];
                        }
                        else
                        {
                            buff1[k] = v1[k] * matrix[k, i];
                            buff2[k] = v2[k] * matrix[k, j];
                        }
                    }
                    outputMatrix[i, j] = Calc.Probability(Calc.Cosinus(buff1, buff2, size));
                }

        }

        int StoreResult()
        {
            StatisticStorage.ClearStr();
            StatisticStorage.Store(similarityOfFiles, similarityOfTags, this.tags, this.files,OccurenceOfTag);
            return 0;
        }
      
    }
}
