﻿//Created by TveMA, 2012
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;

namespace TveMA.Classifier.BYS
{
    class BYS
    {
        double startProb = 0.40;
        double startProbOcc ;
        double weight = 1.0;
        int probabilityBorder;
        double amountofFiles;
        MatrixDbl ProbabilityTagVSTag;
        List<Guid> currentFileTags;
        List<Guid> tags;
        Dictionary<Guid, double> probTagsForFIle;
        Dictionary<Guid, int> occurenceOfTags;

        public BYS(int amountofFiles)
        {
            StatisticStorage.GetMatrix(out ProbabilityTagVSTag, out tags, true);
            StatisticStorage.GetOccurence(out occurenceOfTags);
            currentFileTags = new List<Guid>();
            probTagsForFIle = new Dictionary<Guid, double>(tags.Count);
            this.amountofFiles = (double) amountofFiles;
            startProbOcc = 10 / (this.amountofFiles);
        }


        public void CalcProb(List<string> inputFileTags)
        {
            List<string> newtags = new List<string>(inputFileTags);
            FStorage.Core.CoreFSt core = new FStorage.Core.CoreFSt();
            DataTable tagsNameWithGuid = core.getTags(inputFileTags);
            if (tagsNameWithGuid.Rows.Count != 0)
            {
                foreach (DataRow dr in tagsNameWithGuid.Rows)
                {
                    currentFileTags.Add(new Guid(dr[0].ToString()));
                    newtags.Remove(dr[1].ToString());
                }
            }

            for (int i = 0; i < tags.Count; i++)
            {
                double probTag = Weighted((double)occurenceOfTags[tags[i]] / amountofFiles, occurenceOfTags[tags[i]], startProbOcc);
                double probFileTag = 1;
                foreach (Guid currTag in currentFileTags)
                {
                    if (currTag != tags[i])
                    {
                        int j = tags.FindIndex(f => f == currTag);
                        if (j > i)
                            probFileTag = probFileTag * Weighted(ProbabilityTagVSTag.values[j, i], occurenceOfTags[currTag], startProb);
                        else
                            probFileTag = probFileTag * Weighted(ProbabilityTagVSTag.values[i, j], occurenceOfTags[currTag], startProb);
                    }

                    else
                        probFileTag = 0;
                }
                if (newtags.Count > 0 && probFileTag > 0)
                {
                    foreach (string str in newtags)
                        probFileTag = probFileTag * Weighted(0, 0,startProb);
                }
                probTagsForFIle[tags[i]] = probFileTag * probTag;
                if (probTagsForFIle[tags[i]] > 1)
                    probTagsForFIle[tags[i]] = 0.99;
                else if (probTagsForFIle[tags[i]] < 0)
                    probTagsForFIle[tags[i]] = 0;

            }
        }
        public Dictionary<Guid, double> GetMaxProbTags(int amount, int probabilityBorder)
        {
            this.probabilityBorder = probabilityBorder;
            Dictionary<Guid, double> result = new Dictionary<Guid, double>(amount);
            result = GetMaxProbTags(probTagsForFIle, amount);
            return result;
        }

        public Dictionary<Guid, double> GetMaxProbTags(int amount)
        {
            this.probabilityBorder = 0;
            Dictionary<Guid, double> result = new Dictionary<Guid, double>(amount);
            result = GetMaxProbTags(probTagsForFIle, amount);
            return result;
        }

        private Dictionary<Guid, double> GetMaxProbTags(Dictionary<Guid, double> tagproblist, int amount)
        {
            Dictionary<Guid, double> result = new Dictionary<Guid, double>(amount);
            KeyValuePair<Guid, double> minmax = new KeyValuePair<Guid, double>(Guid.Empty, 0);
            bool filled = false;
            int count = 0;
            foreach (KeyValuePair<Guid, double> tagprob in tagproblist)
            {
                if (minmax.Value <= tagprob.Value)
                {
                    if (!filled)
                    {
                        result.Add(tagprob.Key, tagprob.Value);
                        count++;
                        if (count == amount)
                        {
                            filled = true;
                            minmax = FindMinimum(result);
                        }
                    }
                    else
                    {
                        switchRes(ref result, tagprob, minmax);
                        minmax = FindMinimum(result);
                    }
                }

            }
            return result;
        }

        private void switchRes(ref Dictionary<Guid, double> result, KeyValuePair<Guid, double> tagprob, KeyValuePair<Guid, double> min)
        {
            result.Remove(min.Key);
            result.Add(tagprob.Key, tagprob.Value);
            return;
        }

        private static KeyValuePair<Guid, double> FindMinimum(Dictionary<Guid, double> result)
        {
            KeyValuePair<Guid, double> min = new KeyValuePair<Guid, double>(Guid.Empty, 1000);
            foreach (KeyValuePair<Guid, double> restag in result)
                if (min.Value > restag.Value)
                    min = restag;
            return min;
        }



        private double Weighted(double prob, int amount, double startProb)
        {
            double res = (startProb * weight + (prob * (double)amount) )/ (weight + (double)amount);
            return res;
        }


    }
}
