﻿//Created by TveMA, 2012
using System;
using System.Data;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace TveMA.FStorage.Core.Manager
{
    /// <summary>
    ///  data to manage files
    /// </summary>
    struct DataM
    {
        public string Tags;
        public Guid Id;
        public bool IdIsGiven;
        /// <summary>
        /// file address
        /// </summary>
        public string FAddr;

        public DataM(string file)
        {
            FAddr = file;
            Id = new Guid();
            Tags = "";
            IdIsGiven = false;
        }

        public DataM(string file, string data)
        {
            FAddr = file;
            Id = new Guid();
            Tags = data;
            IdIsGiven = false;
        }

        public DataM(Guid fId)
        {
            Tags = "";
            FAddr = "";
            Id = fId;
            IdIsGiven = true;
        }

        public DataM(Guid fId, string data)
        {
            Id = fId;
            FAddr = "";
            Tags = data;
            IdIsGiven = true;
        }

        /// <summary>
        /// gets name of file
        /// </summary>
        /// <returns></returns>
        public string GetName()
        {
            return GetName(FAddr);
        }

        /// <summary>
        /// gets extension of file
        /// </summary>
        /// <returns></returns>
        public string GetExt()
        {
            return GetExt(FAddr);
        }

        /// <summary>
        /// gets name of file by full file name 
        /// </summary>
        /// <param name="fullName"></param>
        /// <returns></returns>
        public static string GetName(string fullName)
        {
            if (String.IsNullOrEmpty(fullName))
                return "";
            int ind1 = fullName.LastIndexOf('\\');
            int ind = fullName.LastIndexOf('.');
            ind = CheckInd(ind);
            ind1 = CheckInd(ind1);
            if (ind != 0 && ind1 >= ind)
                return "";
            ind1 = (ind1 > 0) ? ind1 + 1 : 0;
            return fullName.Substring(ind1,
                ((ind != 0) ? ind : fullName.Length) - ind1).Trim();
        }

        /// <summary>
        /// gets extension of file by full file name 
        /// </summary>
        /// <param name="fullName"></param>
        /// <returns></returns>
        public static string GetExt(string fullName)
        {
            if (String.IsNullOrEmpty(fullName))
                return "";
            int ind = fullName.LastIndexOf('.');
            ind = CheckInd(ind);
            if (fullName.Length - ind < 4)
            return "";

            return (ind == 0) ? "" : fullName.Substring(ind, 4).Trim();
        }

        /// <summary>
        /// is there extension of the file
        /// </summary>
        /// <param name="fullName"></param>
        /// <returns></returns>
        public static bool HasExt(string fullName)
        {
            return String.IsNullOrEmpty(GetExt(fullName));
        }

        /// <summary>
        /// gets id of file
        /// </summary>
        /// <returns></returns>
        public Guid GetId()
        {
            return (IdIsGiven) ? Id : new Guid(GetName());
        }

        private static int CheckInd(int ind)
        {
            return (ind == -1) ? 0 : ind;
        }

        /// <summary>
        /// is manage data suit to work with
        /// </summary>
        /// <returns></returns>
        internal bool Suit()
        {
            return File.Exists(FAddr) || FAddr=="";
        }
    }
}