﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using System.Windows.Forms;
using Dokan;

namespace VFS
{
    class Program
    {
        static BackgroundWorker dokanWorker;
        static NotifyIcon notfIcon;

        readonly static char driveLetter = Utility.GetFirstAvailableDriveLetter();

        [STAThread()]
        static void Main(string[] args)
        {
            // Set us up a tray-icon to interact with the user;
            SetupNotifyIcon();

            // run the dokan-task
            dokanWorker = new BackgroundWorker();
            dokanWorker.DoWork += delegate
            {
                DokanOptions options = new DokanOptions
                {
                    MountPoint = String.Format("{0}:\\", driveLetter),
                    DebugMode = true,
                    UseStdErr = true,
                    NetworkDrive = false,
                    RemovableDrive = false,       // provides an "eject"-menu to unmount
                    UseKeepAlive = true,        // auto-unmount
                    ThreadCount = (ushort)(System.Diagnostics.Debugger.IsAttached ? 1 : 0),
                    VolumeLabel = "KAPLARO"
                };
                int status = DokanNet.DokanMain(options, new VFS());
                switch (status)
                {
                    case DokanNet.DOKAN_DRIVE_LETTER_ERROR:
                        Console.WriteLine("Drive letter error");
                        break;
                    case DokanNet.DOKAN_DRIVER_INSTALL_ERROR:
                        Console.WriteLine("Driver install error");
                        break;
                    case DokanNet.DOKAN_MOUNT_ERROR:
                        Console.WriteLine("Mount error");
                        break;
                    case DokanNet.DOKAN_START_ERROR:
                        Console.WriteLine("Start error");
                        break;
                    case DokanNet.DOKAN_ERROR:
                        Console.WriteLine("Unknown error");
                        break;
                    case DokanNet.DOKAN_SUCCESS:
                        Console.WriteLine("Success");
                        break;
                    default:
                        Console.WriteLine("Unknown status: %d", status);
                        break;

                }
            };
            dokanWorker.RunWorkerAsync();

            Application.Run();
        }

        private static void SetupNotifyIcon()
        {
            MenuItem[] menuItems = new MenuItem[2];
            menuItems[0] = new MenuItem("&Explore", OnStartExplorer);
            menuItems[1] = new MenuItem("E&xit", OnExit);
            notfIcon = new NotifyIcon();
            notfIcon.Text = String.Format("KAPLARO on {0}:\\", driveLetter);
            notfIcon.Icon = Utility.CreateIcon(driveLetter, System.Drawing.Color.AliceBlue);
            notfIcon.ContextMenu = new ContextMenu(menuItems);
            notfIcon.DoubleClick += OnStartExplorer;
            notfIcon.Visible = true;
        }
        static void OnStartExplorer(object sender, EventArgs e)
        {
            // See http://support.microsoft.com/kb/152457 for a list of command-line args
            // that are supported by Windows Explorer.

            string explorerArgs = string.Format("/e,{0}:\\", driveLetter);
            System.Diagnostics.Process.Start("explorer.exe", explorerArgs);
        }
        static void OnExit(object sender, EventArgs e)
        {
            notfIcon.Visible = false;
            Application.Exit();
        }
    }
}
