﻿//Created by TveMA, 2012
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TveMA.FStorage.Core.Searcher
{
    /// <summary>
    /// data to search by
    /// </summary>
    struct DataS
    {
        public string Name;
        /// <summary>
        /// extension of file
        /// </summary>
        public string Ext;
        /// <summary>
        /// category of file like document, video or image, etc
        /// </summary>
        public string Categ;
        /// <summary>
        /// metadata of file as expressions to search
        /// </summary>
        public string Meta;
        /// <summary>
        /// list of tags
        /// </summary>
        public List<string> Tags;

        /// <summary>
        /// is search data suit to work with
        /// </summary>
        /// <returns></returns>
        internal bool Suit()
        {
            return Tags.Count!=0 || !String.IsNullOrEmpty((Name + Ext + Categ + Meta).Trim());
        }
    }
}
