﻿//Created by TveMA, 2012
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;


namespace TveMA.FStorage.Core.Manager
{
    class DBManager : ManagerI
    {
        private static string ConnectAsync
              = Connect + Core.Properties.Settings.Default.Async;
        private static string Connect = Core.Properties.Settings.Default.FSConnectionString;
        private bool isExecuting;

        public DBManager()
        { }

        public DBManager(DataM data)
            : base(data)
        { }

        /// <summary>
        /// sends query to insert file data to storage
        /// </summary>
        /// <param name="crtd">time of file creation</param>
        /// <param name="modf">time of file modification</param>
        /// <returns></returns>
        public int Insert(DateTime crtd, DateTime modf, long size)
        {
            SqlConnection cn = null;
            SqlTransaction tran = null;
            try
            {
                cn = new SqlConnection(Connect);
                cn.Open();
                tran = cn.BeginTransaction(QString.TransName);
                SqlCommand cm = cn.CreateCommand();
                cm.Transaction = tran;
                cm.CommandType = CommandType.StoredProcedure;
                cm.CommandText = QString.InsrtF;
                cm.Parameters.Add(QParam.Ext, SqlDbType.NVarChar, 4);
                cm.Parameters.Add(QParam.FAddr, SqlDbType.NVarChar, 50);
                cm.Parameters.Add(QParam.Name, SqlDbType.NVarChar, 50);
                cm.Parameters.Add(QParam.FId, SqlDbType.UniqueIdentifier);
                cm.Parameters.Add(QParam.Crtd, SqlDbType.NVarChar, 13);
                cm.Parameters.Add(QParam.Mdf, SqlDbType.NVarChar, 13);
                cm.Parameters.Add(QParam.Size, SqlDbType.BigInt);
                cm.Parameters[1].Value = Core.Properties.Settings.Default.StorageFld;
                cm.Parameters[2].Value = DM.GetName();
                cm.Parameters[0].Value = DM.GetExt();
                cm.Parameters[4].Value = crtd.ToString(QString.DateFormat);
                cm.Parameters[5].Value = modf.ToString(QString.DateFormat);
                cm.Parameters[6].Value = size;
                cm.Parameters[3].Direction = ParameterDirection.Output;
                SqlDataReader reader = cm.ExecuteReader(CommandBehavior.Default);
                DM.Id = (Guid) cm.Parameters[QParam.FId].Value;
                reader.Close();
                if (!String.IsNullOrEmpty(DM.Tags))
                {
                    SqlCommand cm2 = cn.CreateCommand();
                    cm2.Transaction = tran;
                    cm2.CommandType = CommandType.StoredProcedure;
                    cm2.CommandText = QString.CheckExistTags;
                    cm2.Parameters.Add(QParam.List, SqlDbType.NText);
                    cm2.Parameters.Add(QParam.FId, SqlDbType.UniqueIdentifier);
                    cm2.Parameters[0].Value = DM.Tags;
                    cm2.Parameters[1].Value = DM.Id;
                    cm2.ExecuteReader(CommandBehavior.Default).Close();
                }
                DM.Id = (Guid)cm.Parameters[QParam.FId].Value;
                DM.IdIsGiven = true;
                DM.FAddr = Core.Properties.Settings.Default.StorageFld + DM.Id.ToString() + ".fst";
                tran.Commit();
            }
            catch (SqlException ex)
            {
                tran.Rollback(QString.TransName);
                Error = -1;
                ErrorMsg = ex.Message;
                return -1;
            }
            finally
            {
                if (cn != null)
                {
                    cn.Close();
                }
            }
            return 0;
        }

        /// <summary>
        /// sends query to update file data in storage
        /// </summary>
        /// <param name="name">name of file</param>
        /// <returns></returns>
        public int Update(string name)
        {
            SqlConnection cn = null;
            SqlTransaction tran = null;
            try
            {
                cn = new SqlConnection(Connect);
                cn.Open();
                tran = cn.BeginTransaction(QString.TransName);
                if (name != "")
                {
                    SqlCommand cm = cn.CreateCommand();
                    cm.Transaction = tran;
                    cm.CommandType = CommandType.StoredProcedure;
                    cm.CommandText = QString.UpdF;
                    cm.Parameters.Add(QParam.Ext, SqlDbType.NVarChar, 4);
                    cm.Parameters.Add(QParam.Name, SqlDbType.NVarChar, 50);
                    cm.Parameters.Add(QParam.FId, SqlDbType.UniqueIdentifier);
                    cm.Parameters[2].Value = DM.GetId(); ;
                    cm.Parameters[1].Value = DataM.GetName(name);
                    cm.Parameters[0].Value = DataM.GetExt(name);
                    isExecuting = false;
                    cm.ExecuteReader(CommandBehavior.Default).Close();
                }
                if (!String.IsNullOrEmpty(DM.Tags))
                {
                    SqlCommand cm2 = cn.CreateCommand();
                    cm2.Transaction = tran;
                    cm2.CommandType = CommandType.StoredProcedure;
                    cm2.CommandText = QString.UpdTags;
                    cm2.Parameters.Add(QParam.List, SqlDbType.NText);
                    cm2.Parameters.Add(QParam.FId, SqlDbType.UniqueIdentifier);
                    cm2.Parameters[0].Value = DM.Tags;
                    cm2.Parameters[1].Value = DM.GetId();
                    cm2.ExecuteReader(CommandBehavior.Default).Close();
                }
                tran.Commit();
            }
            catch (SqlException ex)
            {
                tran.Rollback(QString.TransName);
                Error = -1;
                ErrorMsg = ex.Message;
                return -1;
            }
            finally
            {
                if (cn != null)
                {
                    cn.Close();
                }
            }
            return 0;

        }
        /// <summary>
        /// sends query to save file data in storage
        /// </summary>
        /// <param name="name">name of file</param>
        /// <param name="modf">time of file modification</param>
        /// <returns></returns>
        public int Save(out string name, DateTime modf,long size)
        {
            SqlConnection cn = null;
            SqlTransaction tran = null;
            name = "";
            try
            {
                GetCloneName(out name);
                if (name != "")
                {
                    cn = new SqlConnection(Connect);
                    cn.Open();
                    tran = cn.BeginTransaction(QString.TransName);
                    SqlCommand cm = cn.CreateCommand();
                    cm.Transaction = tran;
                    cm.CommandType = CommandType.StoredProcedure;
                    cm.CommandText = QString.SaveF;
                    cm.Parameters.Add(QParam.FId, SqlDbType.UniqueIdentifier);
                    cm.Parameters.Add(QParam.Mdf, SqlDbType.NVarChar, 13);
                    cm.Parameters.Add(QParam.Size, SqlDbType.BigInt);
                    cm.Parameters[0].Value = DM.GetId();
                    cm.Parameters[1].Value = modf.ToString(QString.DateFormat);
                    cm.Parameters[2].Value = size;
                    isExecuting = false;
                    cm.ExecuteReader(CommandBehavior.Default).Close();
                    tran.Commit();
                }
            }
            catch (SqlException ex)
            {
                tran.Rollback(QString.TransName);
                Error = -1;
                ErrorMsg = ex.Message;
                return -1;
            }
            finally
            {
                if (cn != null)
                {
                    cn.Close();
                }
            }
            return 0;

        }
        /// <summary>
        /// sends query to get name of clone file and return it as out parameter 
        /// </summary>
        /// <param name="name">name of clone of opened file</param>
        /// <returns></returns>
        public int GetCloneName(out string name)
        {
            SqlConnection cn = null;
            SqlTransaction tran = null;
            try
            {
                cn = new SqlConnection(Connect);
                cn.Open();
                tran = cn.BeginTransaction(QString.TransName);
                SqlCommand cm0 = cn.CreateCommand();
                cm0.Transaction = tran;
                cm0.CommandType = CommandType.Text;
                cm0.CommandText = QString.SELECTTOP1("dbo.GetCloneName(" + QParam.Id + ")");
                cm0.Parameters.Add(QParam.Id, SqlDbType.UniqueIdentifier);
                cm0.Parameters[0].Value = DM.GetId();
                name = (string)cm0.ExecuteScalar();
                tran.Commit();
            }
            catch (SqlException ex)
            {
                tran.Rollback(QString.TransName);
                name = "";
                Error = -1;
                ErrorMsg = ex.Message;
                return -1;
            }
            finally
            {
                if (cn != null)
                {
                    cn.Close();
                }
            }
            return 0;
        }

        /// <summary>
        /// delete file
        /// </summary>
        /// <returns></returns>
        public int Delete()
        {
            SqlConnection cn = null;
            SqlTransaction tran = null;
            try
            {
                cn = new SqlConnection(ConnectAsync);
                cn.Open();
                tran = cn.BeginTransaction(QString.TransName);
                SqlCommand cm = cn.CreateCommand();
                cm.Transaction = tran;
                cm.CommandType = CommandType.StoredProcedure;
                cm.CommandText = "dbo.DeleteF";
                cm.Parameters.Add(QParam.FId, SqlDbType.UniqueIdentifier);
                cm.Parameters[0].Value = DM.GetId();
                isExecuting = true;
                cm.ExecuteReader(CommandBehavior.Default).Close();
                tran.Commit();
            }
            catch (SqlException ex)
            {
                tran.Rollback(QString.TransName);
                Error = -1;
                ErrorMsg = ex.Message;
                return -1;
            }
            finally
            {
                if (cn != null)
                {
                    cn.Close();
                }
            }
            return 0;
        }

        public DataM getNewData()
        {
            return DM;
        }

        /// <summary>
        /// clear data about clones of opened files
        /// </summary>
        /// <returns></returns>
        public int ClearClonesTable()
        {
            SqlTransaction tran = null;
            SqlConnection cn = null;
            try
            {
                cn = new SqlConnection(Connect);
                cn.Open();
                tran = cn.BeginTransaction(QString.TransName);
                SqlCommand cm0 = cn.CreateCommand();
                cm0.Transaction = tran;
                cm0.CommandText = QString.DELETE(QTable.OpF);
                cm0.ExecuteReader(CommandBehavior.Default).Close();
                tran.Commit();
                return 0;
            }
            catch (SqlException ex)
            {
                tran.Rollback(QString.TransName);
                Error = -1;
                ErrorMsg = ex.Message;
                return -1;
            }
            finally
            {
                if (cn != null)
                {
                    cn.Close();
                }
            }
        }

        /// <summary>
        /// delete clone data of file
        /// </summary>
        /// <param name="name">name of clone file</param>
        /// <returns></returns>
        public int DelOneClone(out string name)
        {
            SqlConnection cn = null;
            SqlTransaction tran = null;
            try
            {
                cn = new SqlConnection(Connect);
                cn.Open();
                tran = cn.BeginTransaction(QString.TransName);
                SqlCommand cm0 = cn.CreateCommand();
                cm0.Transaction = tran;
                cm0.CommandText = QString.SELFrWh("name", QTable.OpF, "file_id = @fileId");
                cm0.Parameters.Add(QParam.FId, SqlDbType.UniqueIdentifier);
                cm0.Parameters[0].Value = DM.GetId();
                name = (string)cm0.ExecuteScalar();
                SqlCommand cm1 = cn.CreateCommand();
                cm1.Transaction = tran;
                cm1.CommandText = QString.DELETE(QTable.OpF) + QString.WHERE("file_id = @fileId");
                cm1.Parameters.Add(QParam.FId, SqlDbType.UniqueIdentifier);
                cm1.Parameters[0].Value = DM.GetId();
                cm1.ExecuteReader(CommandBehavior.Default).Close();
                tran.Commit();
                return 0;
            }
            catch (SqlException ex)
            {
                tran.Rollback(QString.TransName);
                Error = -1;
                name = "";
                ErrorMsg = ex.Message;
                return -1;
            }
            finally
            {
                if (cn != null)
                {
                    cn.Close();
                }
            }
        }

        /// <summary>
        /// adds new clone file for opened file 
        /// </summary>
        /// <param name="name">name of clone file</param>
        /// <returns></returns>
        public int AddNewClone(out string name)
        {
            SqlTransaction tran = null;
            SqlConnection cn = null;
            try
            {
                cn = new SqlConnection(Connect);
                cn.Open();
                tran = cn.BeginTransaction(QString.TransName);
                SqlCommand cm0 = cn.CreateCommand();
                cm0.Transaction = tran;
                cm0.CommandText = QString.SELFrWh("name + dbo.GetExtName(id_ext)", QTable.File, "id = @fileId");
                cm0.Parameters.Add(QParam.FId, SqlDbType.UniqueIdentifier);
                cm0.Parameters[0].Value = DM.GetId();
                name = (string)cm0.ExecuteScalar();
                SqlCommand cm1 = cn.CreateCommand();
                cm1.Transaction = tran;
                cm1.CommandType = CommandType.StoredProcedure;
                cm1.CommandText = "dbo.AddToOpenedFiles";
                cm1.Parameters.Add(QParam.FId, SqlDbType.UniqueIdentifier);
                cm1.Parameters[0].Value = DM.GetId();
                cm1.Parameters.Add(QParam.Name, SqlDbType.NVarChar, 50);
                cm1.Parameters[1].Value = name;
                cm1.ExecuteReader(CommandBehavior.Default).Close();
                tran.Commit();
            }
            catch (SqlException ex)
            {
                tran.Rollback(QString.TransName);
                Error = -1;
                name = "";
                ErrorMsg = ex.Message;
                return -1;
            }
            finally
            {
                if (cn != null)
                {
                    cn.Close();
                }
            }
            return 0;
        }
    }
}
