﻿//Created by TveMA, 2012
using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Text;

namespace TveMA.FStorage.Core
{
    enum Acts
    {
        INSERT,
        UPDATE,
        DELETE,
        OPEN,
        CLOSE,
        SAVE,
        CLOSEALL,
        SAVEALL,
        REMOVE
    };
    
    
    public class CoreFSt : ICore
    { 
        public CoreFSt()
        {}
         
        public DataTable search(string data, string name, string extent,
            string categ, string tags, string meta) 
        {
            return Searcher.Searcher.SearchBySent(data, name, extent, categ, tags, meta);
             
        }
        public DataTable search(string name, string extent, string categ,
            string tags, string meta) 
        {
            return Searcher.Searcher.Search(name, extent, categ, tags, meta); ;
        }
        public DataTable searchAll()
        {
            return Searcher.Searcher.GetAll();
        }
        public int update(string fileAddress)
        {
            return Manager.Manager.Work((int)Acts.UPDATE,fileAddress);
        }
        public int update(Guid fileId)
        {
            return Manager.Manager.Work((int)Acts.UPDATE, fileId);
        }
        public int update(string fileAddress, string tags)
        {
            return Manager.Manager.Work((int)Acts.UPDATE, fileAddress, tags);
        }
        public int update(Guid fileId,string tags)
        {
            return Manager.Manager.Work((int)Acts.UPDATE, fileId, tags);
        }

        public int delete(string fileAddress)
        {
            return Manager.Manager.Work((int)Acts.DELETE, fileAddress);
        }
        public int delete(Guid fileId)
        {
            return Manager.Manager.Work((int)Acts.DELETE, fileId);
        }

        public int add(string fileAddress)
        {
            return Manager.Manager.Work((int)Acts.INSERT, fileAddress);
        }
        public int add(string fileAddress, string tags)
        {
            return Manager.Manager.Work((int)Acts.INSERT, fileAddress,tags);
        }

        public int open(string fileAddress)
        {
            return Manager.Manager.Work((int)Acts.OPEN, fileAddress);
        }
        public uint readFile(Guid fileId, byte[] buffer, long offset)
        {
            return Manager.Manager.Work( fileId, buffer, offset);
        }
        public int open(Guid fileId)
        {
            return Manager.Manager.Work((int)Acts.OPEN, fileId);
        }

        public int notSaveChanges(Guid fileId)
        {
            return Manager.Manager.Work((int)Acts.CLOSE, fileId);
        }
        public int notSaveChanges(string fileAddress)
        {
            return Manager.Manager.Work((int)Acts.CLOSE, fileAddress);
        }
        public int notSaveChanges()
        {
            return Manager.Manager.Work((int)Acts.CLOSEALL);
        }
        
        public int saveChanges()
        {
            return Manager.Manager.Work((int)Acts.SAVEALL);
        }
        public int saveChanges(string fileAddress)
        {
            return Manager.Manager.Work((int)Acts.SAVE, fileAddress);
        }
        public int saveChanges(Guid fileId)
        {
            return Manager.Manager.Work((int)Acts.SAVE, fileId);
        }

        public int removeFromStorage(string fileAddress, string newAddress)
        {
            return Manager.Manager.Work((int)Acts.REMOVE, fileAddress,newAddress);
        }
        public int removeFromStorage(Guid fileId, string newAddress)
        {
            return Manager.Manager.Work((int)Acts.REMOVE, fileId, newAddress);
        }

        public DataTable getOpenedFiles()
        {
            return Searcher.Searcher.GetOpenedFiles();
        }
        public DataTable getExtensions()
        {
            return Searcher.Searcher.GetExt();
        }
        public DataTable getCategories()
        {
            return Searcher.Searcher.GetCats();
        }
        public DataTable getTags()
        {
            return Searcher.Searcher.GetTags();
        }
        public DataTable getFiles()
        {
            return Searcher.Searcher.GetFiles();
        }
        public DataTable getTags(List<string> tags)
        {
            return Searcher.Searcher.GetTags(tags);
        }
        public DataTable getTagsOfFile()
        {
            return Searcher.Searcher.GetTagsOfFile();
        }
        public DataTable getExtentOfCategory(string categName)
        {
            return Searcher.Searcher.GetExt(categName);
        }

        public int checkExistOfName(string fullName)
        {
            int index, errCode;
            if ((index = fullName.LastIndexOf('.')) != 0)
            {
                errCode = checkExistOfName(fullName.Substring(0, index), fullName.Substring(index).Trim());
            }
            else
            {
                errCode = checkExistOfName(fullName.Trim(), "");
            }
            return errCode;
        }
        public int checkExistOfName(string name,string extent)
        {
            return 0;

        }
        public int checkExistOfName(string fullName, out DataTable result)
        {
            int index, errCode;
            result = new DataTable(QString.Null);
            
            if ((index = fullName.LastIndexOf('.')) != 0)
            {
                errCode = checkExistOfName(fullName.Substring(0, index).Trim(),
                    fullName.Substring(index).Trim(), out result);
            }
            else
            {
                errCode = checkExistOfName(fullName.Trim(), "",out result);
            }
            return errCode;
        }
        public int checkExistOfName(string name, string extent, out DataTable result)
        {
            result = new DataTable(QString.Null);
            return 0;
        }
    }
}
