use SegmentTree;
use SuffixArray;
use FlowParser;
use Alphabet;
use strict;
use bignum;
use Time::HiRes 'gettimeofday';
use Encode;
sub help {
	print encode "cp866",decode("cp1251",join("",<DATA>));
}
if ($ARGV[0] eq "-h"){help();exit;}
my $data_file =  $ARGV[0];
my $flow = FlowParser->new(".\\nlogs\\".$data_file.".log");
my @ths = @{$flow->GetOrder()};
print "Number of seconds:".($flow->GetTime()/10000000)."\n";
# for (@ths){
	# my @funcs = @{$flow->GetFuncsOfThread($_)};
	# print scalar(@funcs),$/;
# }
for my $thnum(0..4){
	my @funcs = @{$flow->GetFuncsOfThread($ths[$thnum])};
	print "File:$data_file Num of funcs:".scalar(@funcs)."\n";
	open w, ">",".\\nloglcp\\$data_file $thnum.func.txt";
	print w join ",",@funcs;
	close w;
	push @funcs,'0';
	my $al = Alphabet->new(['0']);
	$al->add(\@funcs);
	my @a = ();
	$al->Translate(\@funcs,\@a);
	print "Translated $/";
	my $time = gettimeofday();
	my $c = SuffixArray->new(\@a,$al->GetAlphSize());
	$time = gettimeofday()-$time;
	print "Built on $time $/";
	my $sm = $c->GetArray();
	my $lc = $c->GetLcp();
	my @res = ();
	open w, ">",".\\nloglcp\\$data_file $thnum.smlcp.txt";
	for (my $i=0; $i <= $#$sm; $i++){
		print w $sm->[$i]." ".$lc->[$i]."\n";
	}
	close w;
}
__END__
get_sm.pl -     lcp,       nlogs     
 (.\nloglcp\*.smlcp.txt)       (.\nloglcp\*.func.txt).
	get_sm.pl filename
	filename -      nlog   