#include "entry.h"

static HANDLE MH;
static HANDLE curpid;
static HANDLE curtid;
NTSTATUS CompleteIrp(PIRP Irp, NTSTATUS status, ULONG info)
{
	Irp->IoStatus.Status = status;
	Irp->IoStatus.Information = info; //       ,      , //  .
	IoCompleteRequest(Irp,IO_NO_INCREMENT);
	return status;
}
 
NTSTATUS Create_File_IRP_proc(IN PDEVICE_OBJECT fdo,IN PIRP Irp)
{
	PIO_STACK_LOCATION IrpStack = IoGetCurrentIrpStackLocation(Irp);
	DbgPrint("-Sysenter- Create File is %ws",&(IrpStack->FileObject->FileName.Buffer));
	return CompleteIrp(Irp,STATUS_SUCCESS,0);
}

NTSTATUS DeviceControlRoutine(PDEVICE_OBJECT fdo, PIRP Irp)
{
	UCHAR *buff;
	int i=0;
	NTSTATUS status = STATUS_SUCCESS;
	ULONG BytesTxd = 0;
	UNICODE_STRING u_fName;
	HANDLE hFile;
	IO_STATUS_BLOCK iosb;
	PIO_STACK_LOCATION IrpStack = IoGetCurrentIrpStackLocation(Irp);
	ULONG ControlCode = IrpStack->Parameters.DeviceIoControl.IoControlCode;
	PSYSENTER_EXTENSION pex = (PSYSENTER_EXTENSION)fdo->DeviceExtension;
	ULONG InputLength = IrpStack->Parameters.DeviceIoControl.InputBufferLength;
	ULONG OutputLength = IrpStack->Parameters.DeviceIoControl.OutputBufferLength;
	DbgPrint("-Sysenter- In DeviceControlRoutine (fdo= %X)\n",fdo);
	DbgPrint("-Sysenter- DeviceIoControl: IOCTL %x.", ControlCode);
	switch(ControlCode) {
		case IOCTL_PRINT_DEBUG_MESS: //      
		{ 
			DbgPrint("-Sysenter- I am here!\r\n");
			break;
		}
		case IOCTL_SEND_BYTE_TO_USER: //      
		{		
			buff = (PUCHAR)Irp->AssociatedIrp.SystemBuffer;
			// buffer = |2b - pid|2b - tid|
			if (InputLength<8){
				DbgPrint("-Sysenter- Invalid in buffer len %d",InputLength);
				break;
			}
			curpid = *((HANDLE*)(&buff[0]));
			curtid = *((HANDLE*)(&buff[4]));
			DbgPrint("-Sysenter- Currnet monitoring is p:%d t:%d\r\n",curpid,curtid);
			buff[0]='Y';buff[1]=0;
			BytesTxd = 2;
			break;
		}
		default: status = STATUS_INVALID_DEVICE_REQUEST;
	}
	DbgPrint("-Sysenter- DeviceIoControl: %d bytes written.", (int)BytesTxd);
	return CompleteIrp(Irp,status,BytesTxd); 
}
ULONG OriginalKiFastCallEntry = 0;
#define FUNC_BUFFER 50
static int c = 10;
VOID __stdcall LogSystemCall(int func)
{
	HANDLE pid,tid;
	static UINT32 funcs [FUNC_BUFFER];
	static HANDLE pids [FUNC_BUFFER];
	static HANDLE tids [FUNC_BUFFER];
	static LARGE_INTEGER ticks[FUNC_BUFFER];
	static LARGE_INTEGER time[FUNC_BUFFER];
	static LARGE_INTEGER perf[FUNC_BUFFER];
	static UINT32 cnt=0;
	int f1,f2;
	IO_STATUS_BLOCK iosb;
	int i=0;
	//if (c>0){c--;__asm{int 3}}
	if (cnt == FUNC_BUFFER){
		cnt=0;
		for (i=0;i<FUNC_BUFFER;i++){
			DbgPrint("-Sysenter- f:%d p:%d t:%d perf:%I64d tick:%I64d time:%I64d\r\n",funcs[i],pids[i],tids[i],perf[i],ticks[i],time[i]);
		}
	}else{
		funcs[cnt]=func;
		pid = PsGetCurrentProcessId();
		tid = PsGetCurrentThreadId();
		if ((curpid != 0 && pid == curpid) && (curtid == 0 || curtid == tid) ){
			pids[cnt]=pid;
			tids[cnt]=tid;
			KeQueryTickCount(&ticks[cnt]);
			perf[cnt] = KeQueryPerformanceCounter(0);
			KeQuerySystemTime(&time[cnt]);
			cnt++;
		}
	}
}

VOID __declspec(naked) NewKiFastCallEntry()
{
	__asm
	{
		pushad
		pushfd
		mov ecx, 0x23
		push 0x30
		pop fs
		mov ds, cx
		mov es, cx
		push eax
		call LogSystemCall
		popfd
		popad
		jmp [OriginalKiFastCallEntry]
	}
}
VOID HookSysenter()

{
	DbgPrint("-Sysenter- Hooking sysenter...\n");

	__asm
	{
		mov ecx, IA32_SYSENTER_EIP
		xor edx, edx
		rdmsr
		mov OriginalKiFastCallEntry, eax
		mov eax, NewKiFastCallEntry
		wrmsr
	}

	DbgPrint("-Sysenter- Original KiFastCallEntry address is 0x%08X\n", OriginalKiFastCallEntry);
	DbgPrint("-Sysenter- New KiFastCallEntry address is 0x%08X\n", NewKiFastCallEntry);
	DbgPrint("-Sysenter- Finished hooking sysenter\n");
}

VOID UnhookSysenter()
{
	DbgPrint("-Sysenter- Unhooking sysenter...\n");

	__asm
	{
		mov ecx, IA32_SYSENTER_EIP
		xor edx, edx
		mov eax, OriginalKiFastCallEntry
		wrmsr
	}

	DbgPrint("-Sysenter- Finished unhooking sysenter\n");	
}

VOID OnUnload(PDRIVER_OBJECT driverObject)
{
	UNICODE_STRING symLinkName;
	DbgPrint("-Sysenter- Unloading driver...\n");
	UnhookSysenter();
	RtlInitUnicodeString(&symLinkName, SYM_LINK_NAME);
	IoDeleteSymbolicLink(&symLinkName);
	IoDeleteDevice(driverObject->DeviceObject);
	DbgPrint("-Sysenter- Finished unloading driver\n");
}

NTSTATUS INIT_SYM_LINK(PDRIVER_OBJECT driverObject){
	UNICODE_STRING devName;NTSTATUS status;UNICODE_STRING symLinkName;PDEVICE_OBJECT fdo; 
	PSYSENTER_EXTENSION pex;
	RtlInitUnicodeString(&devName, L"\\Device\\Sysenter");
	RtlInitUnicodeString(&symLinkName, SYM_LINK_NAME);
	status = IoCreateDevice(driverObject,sizeof(SYSENTER_EXTENSION),&devName,FILE_DEVICE_UNKNOWN,0,FALSE, &fdo);
	if (status == STATUS_OBJECT_NAME_EXISTS){
		IoDeleteDevice(fdo);
		status = IoCreateDevice(driverObject,sizeof(SYSENTER_EXTENSION),&devName,FILE_DEVICE_UNKNOWN,0,FALSE, &fdo);
	}
	if(!NT_SUCCESS(status)) return status;
	DbgPrint("-Sysenter- FDO %X.",fdo);
	pex = (PSYSENTER_EXTENSION)fdo->DeviceExtension;
	pex->fdo=fdo;
	pex->ustrSymLinkName = symLinkName;
	pex->hFileLog=0;
	status = IoCreateSymbolicLink(&symLinkName, &devName);
	if (!NT_SUCCESS(status)){
		IoDeleteDevice(fdo);
		return status;
	} 
	return status;
}

NTSTATUS DriverEntry(PDRIVER_OBJECT driverObject, PUNICODE_STRING registryPath)
{
	NTSTATUS status;
	DbgPrint("-Sysenter- Loading driver...\n");
	driverObject->DriverUnload = OnUnload;
	driverObject->MajorFunction[IRP_MJ_CREATE]= Create_File_IRP_proc;
	driverObject->MajorFunction[IRP_MJ_DEVICE_CONTROL]= DeviceControlRoutine;
	
	status = INIT_SYM_LINK(driverObject);
	if (status != STATUS_SUCCESS){
		return status;
	}
	curpid = 0;
	curtid = 0;
	HookSysenter();
	DbgPrint("-Sysenter- Finished loading driver\n");
	return STATUS_SUCCESS;
}