#include <windows.h>
#include <stdio.h>
#include <winioctl.h>
#include <tchar.h>
#include <conio.h>
#include "Ioctl.h"
//         
#define DRIVERNAME _T("Sysenter")
#define DRIVERBINARY _T("C:\\Sysenter\\sysenter.sys")

BOOL InstallDriver(SC_HANDLE scm, LPCTSTR DriverName, LPCTSTR driverExec)
{
	SC_HANDLE Service = CreateService (scm,DriverName,DriverName,SERVICE_ALL_ACCESS,SERVICE_KERNEL_DRIVER,
						   SERVICE_DEMAND_START,SERVICE_ERROR_NORMAL,driverExec,NULL,NULL, NULL, NULL, NULL);
	if (Service == NULL) {
		DWORD err = GetLastError();
		if (err == ERROR_SERVICE_EXISTS) {
			printf("The service is already exists\r\n");
		}
		else 
			printf ("ERR: Cant create service. Err=%d\r\n",err);
		return FALSE;
	}
	CloseServiceHandle (Service);
	return TRUE;
}
//
//      SCM 
BOOL RemoveDriver(SC_HANDLE scm, LPCTSTR DriverName)
{
	SC_HANDLE Service = OpenService (scm, DriverName, SERVICE_ALL_ACCESS);
	if (Service == NULL) return FALSE;
	BOOL ret = DeleteService (Service);
	if (!ret) { 
		printf("Can not remove driver\r\n");
	} 
	CloseServiceHandle (Service);
	return ret;
}

//       SCM 
BOOL StartDriver(SC_HANDLE scm, LPCTSTR DriverName) {
	SC_HANDLE Service = OpenService(scm, DriverName, SERVICE_ALL_ACCESS);
	if (Service == NULL) 
		return FALSE; /* open failed */
	BOOL ret = StartService(Service, 0, NULL); //    
	if (!ret) { 
		DWORD err = GetLastError();
		if (err == ERROR_SERVICE_ALREADY_RUNNING){
			ret = TRUE; //    
			printf("Driver is already started\r\n");
		}
		else { 
			printf ("Can not start driver\r\n");
		}
	}
	CloseServiceHandle (Service);
	return ret;
}
//       SCM 
BOOL StopDriver(SC_HANDLE scm, LPCTSTR DriverName) {
	SC_HANDLE Service = OpenService (scm, DriverName, SERVICE_ALL_ACCESS);
	if (Service == NULL){
		DWORD err = GetLastError();
		printf("Can not stop driver error %d\r\n",err);
		return FALSE;
	}
	SERVICE_STATUS serviceStatus;
	BOOL ret = ControlService(Service, SERVICE_CONTROL_STOP, &serviceStatus);
	if (!ret) {
		DWORD err = GetLastError();
		printf("Can not stop service error %d\r\n",err);
	}
	CloseServiceHandle (Service);
	return ret;
}

//      , , 
//     (  ).
//          ,
//    .
int rmDrv(SC_HANDLE scm){
	BOOL res;
	res = StopDriver (scm, DRIVERNAME);
	if(!res){
		printf("Cannot stop driver!\r\n");
		CloseServiceHandle(scm);
		return -1;
	}
	res = RemoveDriver (scm, DRIVERNAME);
	if(!res){
		printf("Cannot remove driver!\r\n");
		CloseServiceHandle(scm);
		return -1;
	}
	return 0;
}
int __cdecl main(int argc, char* argv[])
{
	BOOL res;
	if (argc == 2 && !strcmp(argv[1],"start")){
		SC_HANDLE scm = OpenSCManager(NULL,NULL,SC_MANAGER_ALL_ACCESS);
		if(scm == NULL) return -1;
		res = InstallDriver(scm, DRIVERNAME, DRIVERBINARY);
		if(!res) {
			printf("Cannot install service\r\n");
		}
		res = StartDriver (scm, DRIVERNAME);
		if(!res) {
			printf("Cannot start driver!\r\n");
			res = RemoveDriver (scm, DRIVERNAME);
			if(!res)
			{
				printf("Cannot remove driver!\r\n");
			}
			CloseServiceHandle(scm); //    SCM
			return -1;
		}
		printf("Driver installed\r\n");
		CloseServiceHandle(scm);
	}else if (argc == 2 && !strcmp(argv[1],"stop")){
		SC_HANDLE scm = OpenSCManager(NULL,NULL,SC_MANAGER_ALL_ACCESS);
		if(scm == NULL) return -1;
		res = StopDriver (scm, DRIVERNAME);
		if(!res){
			printf("Cannot stop driver!\r\n");
		}
		res = RemoveDriver (scm, DRIVERNAME);
		if(!res){
			printf("Cannot remove driver!\r\n");
			CloseServiceHandle(scm);
			return -1;
		}
		printf("Driver removed\r\n");
		CloseServiceHandle(scm);
	} else if (argc == 4 && !strcmp(argv[1],"proc")){		
		HANDLE hHandle = CreateFile(L"\\\\.\\sysenter",GENERIC_READ | GENERIC_WRITE,FILE_SHARE_READ | FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if(hHandle==INVALID_HANDLE_VALUE){
			printf("ERR: can not access driver Primer.sys !\n");
			return 0;
		}
		DWORD BytesReturned;
		char idata [512];
		*((int*)&idata[0])= atoi(argv[2]);
		*((int*)&idata[4])= atoi(argv[3]);
		char odata [512]; 
		if(!DeviceIoControl(hHandle,IOCTL_SEND_BYTE_TO_USER,&idata, sizeof(idata), &odata, sizeof(odata),&BytesReturned,NULL)){
			printf("Error in IOCTL_SEND_BYTE_TO_USER!");
			return 0;
		}
		printf("Driver answer: %s",odata);
		CloseHandle(hHandle);
	}else {
		printf("Usage: sysenter.exe	[start|stop]\r\n			[proc] pid tid\r\n");
	}
	return 0;
}