package SuffixArray;
use strict;
use Data::Dumper;
use SegmentTree;
sub num {
	$_[0]=~/(\d+)/;return $1;
}
sub get {
	my $self = {};
	my $w;
	my $filename = $_[1];
	open $w,"<",$filename or die "!$filename";
	#  
	$/=undef;
	my @ar = ();
	my $str = <$w>;
	@ar = map {num($_)} split /,/,$str;
	#  lcp
	my $filename = $_[2];
	open $w,"<",$filename or die " $! $filename";
	my @sa; my @lcp;
	$/="\n";
	while (my $str = <$w>){
		my @tmp = split ' ',$str;
		push @sa,$tmp[0]+0;
		push @lcp,$tmp[1]+0;
	}
	$self->{str}=\@ar;
	$self->{array} = \@sa;
	$self->{classes} = undef;
	$self->{lcp}=\@lcp;
	bless($self);
	return $self;
}
sub get_str{
	return $_[0]->{str};
}
sub compare_str {
	my ($a,$b,$cmps)=@_;
	my $al = $#$a; my $bl = $#$b;
	my $len = $al<$bl?$al:$bl;
	for my $n(0..$len){
		my $res = $cmps->($a->[$n],$b->[$n]);
		if ( $res != 0 ){
			return $res; 
		}
	}
	if ($al == $bl){
		return 0;
	}
	return $al<$bl?-1:1;
}
sub compare_test{
	return compare_str($_[1],$_[2],$_[3]);
}
sub min {
	return $_[0]<$_[1]?$_[0]:$_[1];
}
sub sarr {
	my $sc = $_[1];
	my @s = @$sc;
	my $n = scalar(@s);
	my $alphabet = $_[2];
	my @p;
	my @cnt=(0) x $alphabet;
	my @c;
	for (my $i=0; $i<$n; ++$i){
		++$cnt[$s[$i]];
	}
	for (my $i=1; $i<$alphabet; ++$i){
		$cnt[$i] += $cnt[$i-1];
	}
	for (my $i=0; $i<$n; ++$i){
		$p[--$cnt[$s[$i]]] = $i;
	}
	$c[$p[0]] = 0;
	my $classes = 1;
	for (my $i=1; $i<$n; ++$i) {
		if ($s[$p[$i]] != $s[$p[$i-1]]){++$classes;}
		$c[$p[$i]] = $classes-1;
	}
	my @lcp=(0) x $n;my @lcpn;my @lpos;my @rpos;
	my @pn;my @cn;
	for (my $h=0; (1<<$h)<$n; ++$h) {
		for (my $i=0; $i<$n; ++$i){$rpos[$c[$p[$i]]] = $i;}
		for (my $i=$n-1; $i>=0; --$i){$lpos[$c[$p[$i]]] = $i;}
		
		for (my $i=0; $i<$n; ++$i) {
			$pn[$i] = $p[$i] - (1<<$h);
			if ($pn[$i] < 0){$pn[$i] += $n;}
		}
		@cnt=(0) x $alphabet;
		for (my $i=0; $i<$n; ++$i){
			++$cnt[$c[$pn[$i]]];
		}
		for (my $i=1; $i<$classes; ++$i){
			$cnt[$i] += $cnt[$i-1];
		}
		for (my $i = $n-1; $i>=0; --$i){
			$p[--$cnt[$c[$pn[$i]]]] = $pn[$i];
		}
		$cn[$p[0]] = 0;
		$classes = 1;
		for (my $i=1; $i<$n; ++$i) {
			my $mid1 = ($p[$i] + (1<<$h)) % $n;
			my $mid2 = ($p[$i-1] + (1<<$h)) % $n;
			if ($c[$p[$i]] != $c[$p[$i-1]] || $c[$mid1] != $c[$mid2]){
				++$classes;
			}
			$cn[$p[$i]] = $classes-1;
		}
		my $st = SegmentTree->new(\@lcp,\&min);
		for (my $i=0; $i<$n-1; ++$i) {
			my $a = $p[$i],  $b = $p[$i+1];
			if ($c[$a] != $c[$b]){
				$lcpn[$i] = $lcp[$rpos[$c[$a]]];
			}
			else {
				my $aa = ($a + (1<<$h)) % $n; 
				my $bb = ($b + (1<<$h)) % $n;
				$lcpn[$i] = (1<<$h) + 
					$st->get($lpos[$c[$aa]], $rpos[$c[$bb]]-1);
				$lcpn[$i] = min ($n, $lcpn[$i]);
			}
		}
		@lcp = @lcpn;
		@c = @cn;
	}
	return \@p,\@c,\@lcp;
}
sub new {
	my $self = {};
	my $ar = $_[1];
	my ($p,$c,$lcp) = sarr($self,$ar,$_[2]);
	$self->{str}=$ar;
	$self->{array} = $p;
	$self->{classes} = $c;
	$self->{lcp}=$lcp;
	bless($self);
	return $self;
}
sub GetArray{
	return $_[0]->{array};
}
sub GetLcp{
	return $_[0]->{lcp};
}
sub print {
	my ($self)=@_;
	for (my $idx=0;$idx < scalar(@{$self->{array}}); $idx++){
		print join ",",map {chr($_)}@{$self->{str}}[$self->{array}->[$idx]..$#{$self->{str}}];
		print "		".$self->{lcp}->[$idx];
		print $/;
		
	}
}
sub find_seq{
	my ($self,$seq)=@_;
	my $ip = find($self,$seq,0,1+$#{$self->{array}});
	my ($imax,$imin)=(0,0);
	my $len = scalar(@$seq);
	for ($imax = $ip; $imax <=$#{$self->{array}};$imax++ ){
		if ( $self->{lcp}->[$imax] < $len){
			last;
		}
	}
	for ($imin = $ip; $imin >0; $imin-- ){
		if ( $self->{lcp}->[$imin-1] < $len){
			last;
		}
	}
	return ($imin,$imax);
}
sub cmpr {
	return $_[0] <=> $_[1];
}
sub find {
	my ($self,$seq,$start,$end)=@_;
	my $idx = $start + int (($end-$start)/2);
	my $len = scalar(@$seq);
	my @f = @{$self->{str}}[$self->{array}->[$idx]..$self->{array}->[$idx]+$len-1];
	my $res = compare_str(\@f,$seq,\&cmpr);
	# print join ",",@f,"/";
	# print join ",",@$seq,"/";
	# print " - $res  $start $idx  $end $/";
	if ( $res == -1){
		return find($self,$seq,$idx,$end);
	}
	elsif ($res == 1){
		return find($self,$seq,$start,$idx);
	}else{
		# print "$idx ".$self->{array}->[$idx],$/;
		# print join ",",@{$self->{array}},$/;
		return $idx;
	}
}
1;