package SegmentTree;


sub build {
	my ($t,$a,$v,$tl,$tr,$func)=@_;
	if ($tl == $tr){
		$t->[$v] = $a->[$tl];}
	else {
		my $tm = int(($tl + $tr) / 2);
		build ($t, $a, $v*2, $tl, $tm,$func);
		build ($t, $a, $v*2+1, $tm+1, $tr,$func);
		$t->[$v] = $func->($t->[$v*2], $t->[$v*2+1]);
	}
}
sub new {
	my $dt = $_[1];
	my $func = $_[2];
	my $n = scalar(@$dt);
	my $self={};
	my @t = (0) x 4*$n; 
	build(\@t,$dt,1,0,$n-1,$func);
	$self->{cnt}=$n;
	$self->{tree} = \@t;
	$self->{func} = $func;
	bless($self);
	return $self;
}

sub min {
	return $_[0]<$_[1]?$_[0]:$_[1];
}
sub max {
	return $_[0]>$_[1]?$_[0]:$_[1];
}
sub mget {
	my ($self,$v, $tl, $tr, $l, $r)=@_;
	my $t = $self->{tree};
	if ($l > $r){
		return undef;
	}
	if ($l == $tl && $r == $tr){
		return $t->[$v];
	}
	my $tm = int(($tl + $tr) / 2);
	my $r1;my $r2;my $res;
	my $r1 = mget ($self, $v*2, $tl, $tm, $l, min($r,$tm));
	my $r2 = mget ($self, $v*2+1, $tm+1, $tr, max($l,$tm+1), $r);
	if (defined($r1) && defined($r2)){
		return $self->{func}->($r1,$r2);
	}
	if (defined($r1)){
		return $r1;
	}
	if (defined($r2)){
		return $r2;
	}
	return undef;
}

sub get{
	my ($self,$l,$r)=@_;
	return mget($self,1,0,$self->{cnt}-1,$l,$r);
}
1;