#!/usr/bin/perl
use PPM;
use FlowParser;
use DrawGraphic;
use Blur;
use Encode;
sub help {
	print encode "cp866",decode("cp1251",join("",<DATA>));
}
if ($ARGV[0] eq "-h"){help();exit;}
$dt = $ARGV[0] or "Explorer 0";
$data_file = ".\\nloglcp\\$dt.func.txt";
open w, "$data_file"  or die $!;
$/=undef;
$all = <w>;
@funcs = split ',',$all;
$ppm_t = PPM->new();
my $bits = $ppm_t->ComputeTree(\@funcs,9);
$sum=0;
for(my $k=0;$k<scalar(@$bits);$k++){
	$sum+=$bits->[$k];
}
$sum = $sum/scalar(@$bits);
$disp= 0;
for(my $k=0;$k<scalar(@$bits);$k++){
	$disp+=($bits->[$k]-$sum)*($bits->[$k]-$sum);
}
$disp = sqrt($disp/scalar(@$bits));
print "\nAvg is ".$sum;
print "\nDisp is ".$disp;


#DrawGraphic::DrawGraphX([0..$#$bits],$bits,$data_file."_enthropy.png");

#@bdata= Blur::BlurDataSum($bits,20);
#DrawGraphic::DrawGraph(\@bdata,$data_file."_enthropy_blur20.png");

__END__
PPMCompute.pl -         PPM.
	PPMCompute.pl filename
	filename -         nloglcp