package Alphabet;
use strict;
use Data::Dumper;
sub new { #         
	my (undef,$symbs) = @_;
	my $self={};
	my %codes = ();
	my @alf = ();
	for my $c(@$symbs){
		if (!defined($codes{$c})){
			push @alf, $c;
			$codes{$c} = $#alf;
		}
	}
	($self->{codes},$self->{alf}) = (\%codes,\@alf);
	bless($self);
	return $self;
}
sub add {
	my ($self,$symbs) = @_;
	for my $c(@$symbs){
		if (!defined($self->{codes}->{$c})){
			push @{$self->{alf}}, $c;
			$self->{codes}->{$c} = $#{$self->{alf}};
		}
	}
}
sub Translate {
	my ($self,$src,$dst) = @_;
	for (@$src){
		push @$dst, $self->{codes}->{$_};
	}
}
sub UnTranslate {
	my ($self,$src,$dst) = @_;
	for (@$src){
		push @$dst, $self->{alf}->[$_];
	}
}
sub AddToAlphabet {
	my ($self,$str) = @_;
	push @{$self->{alf}}, $str;
	$self->{codes}->{$str} = $#{$self->{alf}};
}
sub IsInAlf{
	my ($self,$code) = @_;
	return defined($self->{codes}->{$code});
}
sub GetCodeFor {
	my ($self,$sym) = @_;
	return $self->{codes}->{$sym};
}
sub GetAlfFor {
	my ($self,$num) = @_;
	return $self->{alf}->[$num];
}
sub GetCodes{
	my ($self)=@_;
	return $self->{codes};
}
sub GetAlph{
	my ($self)=@_;
	return $self->{alf};
}
sub GetAlphSize{
	my ($self)=@_;
	return scalar(@{$self->{alf}});
}
1;