#!/usr/bin/perl
package PPM;
use Data::Dumper;
sub m_round{
	return sprintf "%.5f", $_[0];
}
sub m_dump{
	my ($x)=$_[0];
	$x=~s/   / /g;	
	return $x;
}
sub new {
	return $_[0];
}
sub ComputeTree {
	my ($self,$symbols) = @_;
	my $cont_length = $_[2] or 9;
	print "cont:$cont_length\r\n";
	my %dict=();
	for(@{$symbols}){
		$dict{$_}=1;
	}
	my @bits=();
	print "Sym count:".scalar(keys %dict),$/;
	my %contexts = (subtree=>{},count=>0,symbols=>{});
	#print join ",",@symbols;
	my $prefix_pos = 0;
	print $/;
	for $pos(0..$#{$symbols}){
		my $sym = ${$symbols}[$pos];
		my @prefix=();
		my $cur_lev = \%contexts;
		my @levels = ();
		@prefix = reverse @{$symbols}[$prefix_pos..$pos-1];
		push @levels, $cur_lev;	#    
		$cur_lev = $cur_lev->{subtree}; 
		#              .
		for $sym ( @prefix ){
			if (defined($cur_lev->{$sym})){ #       
				$cur_lev->{$sym}->{count}++;
				push @levels, $cur_lev->{$sym};
				$cur_lev = $cur_lev->{$sym}->{subtree};
			}
			else{
				$cur_lev->{$sym} = {subtree=>{},count=>1,symbols=>{}};
				push @levels, $cur_lev->{$sym};
				$cur_lev = $cur_lev->{$sym}->{subtree};
			}
		}
		#print "levels:".m_dump Data::Dumper::Dumper(\@levels);
		my %mask=();
		my $level_num=$#levels;
		my $p_cur = 1;
		my $code = "(";
		#  levels  ,    .           .
		for $lev(reverse @levels){
	#		print join ",",%mask,"|",$/;
			if (defined($lev->{symbols}->{$sym})){
				my %active_symbols;
				my $count_sym = 0;
				while (my ($k,$v)=each(%{$lev->{symbols}})){#       
					if (!defined($mask{$k})){
						$active_symbols{$k}=$v;
						$count_sym+=$v;
					}
				}
				if (length(keys %active_symbols)!=0){$code.="$sym)";}else{$code.=")";}
				my $p = (1.0*$lev->{symbols}->{$sym}) / (1.0*$count_sym+1);
				$p_cur = $p_cur *  $p;
				$bit=m_round(-log($p_cur)/log(2.0));
				push @bits,$bit;
				#print $count_sym," ",,$/;
				#print "level:$level_num sym:'$sym' count:".${$lev}{symbols}{$sym}." code:$code p: $p_cur c_count:$count_sym! bits:".$bit.$/;
				last;
			}else{
				my %active_symbols;
				my $count_sym = 0;
				while (my ($k,$v)=each(%{$lev->{symbols}})){#       
					if (!defined($mask{$k})){
						$active_symbols{$k}=$v;
						$count_sym+=$v;
					}
				}
				if ($level_num == 0){
					if (!defined($lev->{symbols}->{$sym})){$count_sym++;}
					$code.="$sym)";
					my $p = 1.0/$count_sym ;#/ (1.0*scalar(keys %{$contexts{subtree}}));
					$p_cur = $p_cur *  $p;
					$bit=m_round(-log($p_cur)/log(2.0));
					push @bits,$bit;
					#print "level:$level_num sym:'$sym' count:1 code:$code p: $p_cur bits:".$bit.$/;					
				}else{
					$level_num--;					
					for $msk_sym(keys %{$lev->{symbols}}){ #       
						$mask{$msk_sym} = 1;
					}
					$p_cur *= 1.0/($count_sym+1); #    .
					$code.="<esc>";
					#print "Esc with ".1.0/($count_sym+1).$/;
				}
			}
		}
		#    
		for $lev(reverse @levels){
			if (defined($lev->{symbols}->{$sym})){
				$lev->{symbols}->{$sym}++;
			}else{
				$lev->{symbols}->{$sym}=1;
			}
		}
		#print m_dump Data::Dumper::Dumper(\@levels);
		if ($pos - $prefix_pos > $cont_length-1){$prefix_pos++;}
	#	print "-" x 30 ,$/;
	}
	$self->{contexts} = \%contexts;
	my $out_file;
	#open $out_file, ">report_bits.txt" or die $!;
	#print $out_file join "\n", map {$_=~s/\./,/g;$_} @bits;
	#print m_dump Data::Dumper::Dumper(\%contexts);
	return \@bits;
}
1;