package FlowParser;
use Data::Dumper;
use bignum;
#  -,   
#    -   
#    ,  .
sub new {
	my ($self,$fname) = @_;
	my $self={};
	$self->{threads}={};
	my $if;
	$/="\n";
	open $lf, "$fname" or die $!." $fname";
	my $cnt = 0;
	my ($starttime,$endtime)=(0,0);
	while (my $logline = <$lf>){
		if ($logline=~/-Sysenter-\s+f:(\d+)\sp:(\d+)\s+t:(\d+)\s+perf:(\d+)\s+tick:(\d+)\s+time:(\d+)/){
			if ($starttime == 0){
				$starttime = $6;
			}
			$endtime = $6;
			$cnt++;
			push @{${$self->{threads}}{$3}}, {func => $1, cnt=>$cnt, perf=>$4, 'ticks'=>$5,'time'=>$6};
		}
	}
	$self->{worktime} = $endtime - $starttime;
	@{$self->{thordered}}=();
	$self->{thordered}=[
		sort {scalar(@{$self->{threads}->{$b}}) <=> scalar(@{$self->{threads}->{$a}})} keys %{$self->{threads}}
		];
	close $lf;
	$self->{blocks}=undef;
	$self->{counts}=undef;
	bless($self);
	return $self;
}
sub GetTime{
	return $_[0]->{worktime};
}
sub GetOrder{
	my ($self) = @_;
	return $self->{thordered};
}
sub get_info {
	my ($self) = @_;
	return $self->{threads};
}
sub GetFuncsOfThread{
	my ($self,$thnum) = @_;
	my @fs = map {$_->{func}} @{$self->{threads}{$thnum}};
	return \@fs;
}
sub GetTicksOfThread{
	my ($self,$thnum) = @_;
	my @ts = map {$_->{ticks}} @{$self->{threads}{$thnum}};
	return \@ts;
}
sub split_to_blocks {
	my ($self,$tid,$block_len)=@_;
	my $threads = $self->{threads};
	my @t_calls = @{${$threads}{$tid}};
	if ($#t_calls<=$block_len){
		return 0;
	}
	my @blocks=();
	my %substrs = ();
	for $i(0..$#t_calls-$block_len){
		@b=();
		for $b(0..$block_len-1){
			push @b, ${$t_calls[$i+$b]}{func};
		}
		$s=join("-",@b);
		push @blocks,$s;
		if (defined($substrs{$s})){
			$substrs{$s}++;
		}
		else{
			$substrs{$s}=1;
		}
	}
	$self->{blocks}=\@blocks; #  
	$self->{counts}=\%substrs; #   
	return 0+@blocks;
}
sub get_blocks{
	my ($self) = @_;
	return $self->{blocks};
}
sub get_block_count{
	my ($self,$chain) = @_;
	return scalar(@{$self->{blocks}});
}
sub get_count{
	my ($self,$chain) = @_;
	return ${$self->{counts}}{$chain};
}
1;