package DrawGraphic;
use GD::Graph::points;
use Data::Dumper;
%params = (
	caption => "Enthropy graphic",
	x => 2*1024,
	y => 512,
	xcap => "Call number",
	ycap => "enthropy"
);
$max = 0;
sub SetParams{
	my ($x)=@_;
	for my $k(keys %$x){
		$params{$k} = $x->{$k};
	}
}
#     ,  x-   .
sub DrawGraph {
	my ($in_data,$filename)= @_;
	my @data = ([(undef) x 1+$#$in_data ],$in_data);
	my $mygraph = GD::Graph::points->new($params{x},$params{y});
	
	$mygraph->set(
		x_tick_number => 'auto',
		x_label     => $params{xcap},
		y_label     => $params{ycap},
		title       => $params{caption},
		markers => [7],
		marker_size => 2,
		dclrs       => ['blue'],
	) or warn $mygraph->error;
	my $myimage = $mygraph->plot(\@data) or die $mygraph->error;
	my $wfile;
	open $wfile, ">",$filename or die $!;
	binmode $wfile;
	print $wfile $myimage->png;
	close $wfile;
}
sub DrawGraphX {
	my ($xs,$in_data,$filename)= @_;
	my @data = ($xs,$in_data);
	my $mygraph = GD::Graph::points->new($params{x},$params{y});
	$mygraph->set(
		x_label     => $params{xcap},
		y_label     => $params{ycap},
		title       => $params{caption},
		markers => [7],
		marker_size => 2,
		dclrs       => ['blue'],
	) or warn $mygraph->error;
	my $myimage = $mygraph->plot(\@data) or die $mygraph->error;
	my $wfile;
	open $wfile, ">",$filename or die $!;
	binmode $wfile;
	print $wfile $myimage->png;
	close $wfile;
}
return 1;
__END__
#     ,  x-   .