set define '^'
set verify off
set serveroutput on size 1000000
set feedback off
WHENEVER SQLERROR EXIT SQL.SQLCODE ROLLBACK
 
prompt  Set Credentials...
 
begin
 
  -- Assumes you are running the script connected to sqlplus as the schema associated with the UI defaults or as the product schema.
  wwv_flow_api.set_security_group_id(p_security_group_id=>56868076019821425474);
 
end;
/

begin wwv_flow.g_import_in_progress := true; end;
/
begin 

select value into wwv_flow_api.g_nls_numeric_chars from nls_session_parameters where parameter='NLS_NUMERIC_CHARACTERS';

end;

/
begin execute immediate 'alter session set nls_numeric_characters=''.,''';

end;

/
begin wwv_flow.g_browser_language := 'en'; end;
/
prompt  Check Compatibility...
 
begin
 
-- This date identifies the minimum version required to install this file.
wwv_flow_api.set_version(p_version_yyyy_mm_dd=>'2011.02.12');
 
end;
/

-- SET SCHEMA
 
begin
 
   wwv_flow_api.g_id_offset := 0;
   wwv_flow_hint.g_schema   := 'LS_SCHEMA';
   wwv_flow_hint.check_schema_privs;
 
end;
/

 
--------------------------------------------------------------------
prompt  SCHEMA LS_SCHEMA - User Interface Defaults, Table Defaults
--
-- Import using sqlplus as the Oracle user: APEX_040100
-- Exported 08:30 Thursday June 7, 2012 by: ZMEIKA888@YANDEX.RU
--
 
begin
 
wwv_flow_hint.remove_hint_priv(wwv_flow_hint.g_schema,'SBERBANK');
wwv_flow_hint.create_table_hint_priv(
  p_table_id => 62757455532518490548 + wwv_flow_api.g_id_offset,
  p_schema => wwv_flow_hint.g_schema,
  p_table_name  => 'SBERBANK',
  p_report_region_title => 'Sberbank',
  p_form_region_title => 'Sberbank');
 
end;
/

 
begin
 
wwv_flow_hint.create_column_hint_priv(
  p_label => 'Close',
  p_display_seq_form => 7,
  p_display_in_form => 'Y',
  p_display_as_form => 'NATIVE_NUMBER_FIELD',
  p_form_attribute_03 => 'right',
  p_display_as_tab_form => 'TEXT',
  p_display_seq_report => 7,
  p_display_in_report => 'Y',
  p_display_as_report => 'WITHOUT_MODIFICATION',
  p_aggregate_by => 'N',
  p_required => 'N',
  p_alignment => 'R',
  p_display_width => 30,
  p_max_width => 22,
  p_height => 1,
  p_group_by => 'N',
  p_searchable => 'N',
  p_column_id => 62757456225029490588 + wwv_flow_api.g_id_offset,
  p_table_id => 62757455532518490548 + wwv_flow_api.g_id_offset,
  p_column_name => 'CLOSE');
 
end;
/

 
begin
 
wwv_flow_hint.create_column_hint_priv(
  p_label => 'Dates',
  p_display_seq_form => 2,
  p_display_in_form => 'Y',
  p_display_as_form => 'NATIVE_NUMBER_FIELD',
  p_form_attribute_03 => 'right',
  p_display_as_tab_form => 'TEXT',
  p_display_seq_report => 2,
  p_display_in_report => 'Y',
  p_display_as_report => 'WITHOUT_MODIFICATION',
  p_aggregate_by => 'N',
  p_required => 'N',
  p_alignment => 'R',
  p_display_width => 30,
  p_max_width => 22,
  p_height => 1,
  p_group_by => 'N',
  p_searchable => 'N',
  p_column_id => 62757455727255490587 + wwv_flow_api.g_id_offset,
  p_table_id => 62757455532518490548 + wwv_flow_api.g_id_offset,
  p_column_name => 'DATES');
 
end;
/

 
begin
 
wwv_flow_hint.create_column_hint_priv(
  p_label => 'High',
  p_display_seq_form => 5,
  p_display_in_form => 'Y',
  p_display_as_form => 'NATIVE_NUMBER_FIELD',
  p_form_attribute_03 => 'right',
  p_display_as_tab_form => 'TEXT',
  p_display_seq_report => 5,
  p_display_in_report => 'Y',
  p_display_as_report => 'WITHOUT_MODIFICATION',
  p_aggregate_by => 'N',
  p_required => 'N',
  p_alignment => 'R',
  p_display_width => 30,
  p_max_width => 22,
  p_height => 1,
  p_group_by => 'N',
  p_searchable => 'N',
  p_column_id => 62757456007092490588 + wwv_flow_api.g_id_offset,
  p_table_id => 62757455532518490548 + wwv_flow_api.g_id_offset,
  p_column_name => 'HIGH');
 
end;
/

 
begin
 
wwv_flow_hint.create_column_hint_priv(
  p_label => 'Id',
  p_display_seq_form => 1,
  p_display_in_form => 'Y',
  p_display_as_form => 'NATIVE_NUMBER_FIELD',
  p_form_attribute_03 => 'right',
  p_display_as_tab_form => 'TEXT',
  p_display_seq_report => 1,
  p_display_in_report => 'Y',
  p_display_as_report => 'WITHOUT_MODIFICATION',
  p_aggregate_by => 'N',
  p_required => 'Y',
  p_alignment => 'R',
  p_display_width => 30,
  p_max_width => 22,
  p_height => 1,
  p_group_by => 'N',
  p_searchable => 'N',
  p_column_id => 62757455602253490573 + wwv_flow_api.g_id_offset,
  p_table_id => 62757455532518490548 + wwv_flow_api.g_id_offset,
  p_column_name => 'ID');
 
end;
/

 
begin
 
wwv_flow_hint.create_column_hint_priv(
  p_label => 'Low',
  p_display_seq_form => 6,
  p_display_in_form => 'Y',
  p_display_as_form => 'NATIVE_NUMBER_FIELD',
  p_form_attribute_03 => 'right',
  p_display_as_tab_form => 'TEXT',
  p_display_seq_report => 6,
  p_display_in_report => 'Y',
  p_display_as_report => 'WITHOUT_MODIFICATION',
  p_aggregate_by => 'N',
  p_required => 'N',
  p_alignment => 'R',
  p_display_width => 30,
  p_max_width => 22,
  p_height => 1,
  p_group_by => 'N',
  p_searchable => 'N',
  p_column_id => 62757456110765490588 + wwv_flow_api.g_id_offset,
  p_table_id => 62757455532518490548 + wwv_flow_api.g_id_offset,
  p_column_name => 'LOW');
 
end;
/

 
begin
 
wwv_flow_hint.create_column_hint_priv(
  p_label => 'Open',
  p_display_seq_form => 4,
  p_display_in_form => 'Y',
  p_display_as_form => 'NATIVE_NUMBER_FIELD',
  p_form_attribute_03 => 'right',
  p_display_as_tab_form => 'TEXT',
  p_display_seq_report => 4,
  p_display_in_report => 'Y',
  p_display_as_report => 'WITHOUT_MODIFICATION',
  p_aggregate_by => 'N',
  p_required => 'N',
  p_alignment => 'R',
  p_display_width => 30,
  p_max_width => 22,
  p_height => 1,
  p_group_by => 'N',
  p_searchable => 'N',
  p_column_id => 62757455930518490588 + wwv_flow_api.g_id_offset,
  p_table_id => 62757455532518490548 + wwv_flow_api.g_id_offset,
  p_column_name => 'OPEN');
 
end;
/

 
begin
 
wwv_flow_hint.create_column_hint_priv(
  p_label => 'Time',
  p_display_seq_form => 3,
  p_display_in_form => 'Y',
  p_display_as_form => 'NATIVE_NUMBER_FIELD',
  p_form_attribute_03 => 'right',
  p_display_as_tab_form => 'TEXT',
  p_display_seq_report => 3,
  p_display_in_report => 'Y',
  p_display_as_report => 'WITHOUT_MODIFICATION',
  p_aggregate_by => 'N',
  p_required => 'N',
  p_alignment => 'R',
  p_display_width => 30,
  p_max_width => 22,
  p_height => 1,
  p_group_by => 'N',
  p_searchable => 'N',
  p_column_id => 62757455818295490588 + wwv_flow_api.g_id_offset,
  p_table_id => 62757455532518490548 + wwv_flow_api.g_id_offset,
  p_column_name => 'TIME');
 
end;
/

 
begin
 
wwv_flow_hint.remove_hint_priv(wwv_flow_hint.g_schema,'TEST');
wwv_flow_hint.create_table_hint_priv(
  p_table_id => 58884015001897950015 + wwv_flow_api.g_id_offset,
  p_schema => wwv_flow_hint.g_schema,
  p_table_name  => 'TEST',
  p_report_region_title => 'Test',
  p_form_region_title => 'Test');
 
end;
/

 
begin
 
wwv_flow_hint.create_column_hint_priv(
  p_label => 'Columndate',
  p_display_seq_form => 2,
  p_display_in_form => 'Y',
  p_display_as_form => 'NATIVE_TEXT_FIELD',
  p_form_attribute_01 => 'N',
  p_form_attribute_02 => 'N',
  p_form_attribute_03 => 'N',
  p_display_as_tab_form => 'TEXT',
  p_display_seq_report => 2,
  p_display_in_report => 'Y',
  p_display_as_report => 'WITHOUT_MODIFICATION',
  p_aggregate_by => 'N',
  p_required => 'N',
  p_alignment => 'L',
  p_display_width => 60,
  p_max_width => 30,
  p_height => 1,
  p_group_by => 'N',
  p_searchable => 'Y',
  p_column_id => 58884015218440950017 + wwv_flow_api.g_id_offset,
  p_table_id => 58884015001897950015 + wwv_flow_api.g_id_offset,
  p_column_name => 'COLUMNDATE');
 
end;
/

 
begin
 
wwv_flow_hint.create_column_hint_priv(
  p_label => 'Columnvalue',
  p_display_seq_form => 3,
  p_display_in_form => 'Y',
  p_display_as_form => 'NATIVE_NUMBER_FIELD',
  p_form_attribute_03 => 'right',
  p_display_as_tab_form => 'TEXT',
  p_display_seq_report => 3,
  p_display_in_report => 'Y',
  p_display_as_report => 'WITHOUT_MODIFICATION',
  p_aggregate_by => 'N',
  p_required => 'N',
  p_alignment => 'R',
  p_display_width => 30,
  p_max_width => 22,
  p_height => 1,
  p_group_by => 'N',
  p_searchable => 'N',
  p_column_id => 58884015332724950017 + wwv_flow_api.g_id_offset,
  p_table_id => 58884015001897950015 + wwv_flow_api.g_id_offset,
  p_column_name => 'COLUMNVALUE');
 
end;
/

 
begin
 
wwv_flow_hint.create_column_hint_priv(
  p_label => 'Id',
  p_display_seq_form => 1,
  p_display_in_form => 'Y',
  p_display_as_form => 'NATIVE_NUMBER_FIELD',
  p_form_attribute_03 => 'right',
  p_display_as_tab_form => 'TEXT',
  p_display_seq_report => 1,
  p_display_in_report => 'Y',
  p_display_as_report => 'WITHOUT_MODIFICATION',
  p_aggregate_by => 'N',
  p_required => 'Y',
  p_alignment => 'R',
  p_display_width => 30,
  p_max_width => 22,
  p_height => 1,
  p_group_by => 'N',
  p_searchable => 'N',
  p_column_id => 58884015108410950017 + wwv_flow_api.g_id_offset,
  p_table_id => 58884015001897950015 + wwv_flow_api.g_id_offset,
  p_column_name => 'ID');
 
end;
/

 
begin
 
wwv_flow_hint.remove_hint_priv(wwv_flow_hint.g_schema,'TEST111');
wwv_flow_hint.create_table_hint_priv(
  p_table_id => 58882542420124804798 + wwv_flow_api.g_id_offset,
  p_schema => wwv_flow_hint.g_schema,
  p_table_name  => 'TEST111',
  p_report_region_title => 'Test111',
  p_form_region_title => 'Test111');
 
end;
/

 
begin
 
wwv_flow_hint.create_column_hint_priv(
  p_label => 'ColumnX',
  p_display_seq_form => 3,
  p_display_in_form => 'Y',
  p_display_as_form => 'NATIVE_NUMBER_FIELD',
  p_form_attribute_03 => 'right',
  p_display_as_tab_form => 'TEXT',
  p_display_seq_report => 3,
  p_display_in_report => 'Y',
  p_display_as_report => 'WITHOUT_MODIFICATION',
  p_aggregate_by => 'N',
  p_required => 'N',
  p_alignment => 'R',
  p_display_width => 30,
  p_max_width => 22,
  p_height => 1,
  p_group_by => 'N',
  p_searchable => 'N',
  p_column_id => 58882542726599804800 + wwv_flow_api.g_id_offset,
  p_table_id => 58882542420124804798 + wwv_flow_api.g_id_offset,
  p_column_name => 'COLUMNX');
 
end;
/

 
begin
 
wwv_flow_hint.create_column_hint_priv(
  p_label => 'ColumnY',
  p_display_seq_form => 2,
  p_display_in_form => 'Y',
  p_display_as_form => 'NATIVE_TEXT_FIELD',
  p_form_attribute_01 => 'N',
  p_form_attribute_02 => 'N',
  p_form_attribute_03 => 'N',
  p_display_as_tab_form => 'TEXT',
  p_display_seq_report => 2,
  p_display_in_report => 'Y',
  p_display_as_report => 'WITHOUT_MODIFICATION',
  p_aggregate_by => 'N',
  p_required => 'N',
  p_alignment => 'L',
  p_display_width => 60,
  p_max_width => 30,
  p_height => 1,
  p_group_by => 'N',
  p_searchable => 'Y',
  p_column_id => 58882542628888804800 + wwv_flow_api.g_id_offset,
  p_table_id => 58882542420124804798 + wwv_flow_api.g_id_offset,
  p_column_name => 'COLUMNY');
 
end;
/

 
begin
 
wwv_flow_hint.create_column_hint_priv(
  p_label => 'Id',
  p_display_seq_form => 1,
  p_display_in_form => 'Y',
  p_display_as_form => 'NATIVE_NUMBER_FIELD',
  p_form_attribute_03 => 'right',
  p_display_as_tab_form => 'TEXT',
  p_display_seq_report => 1,
  p_display_in_report => 'Y',
  p_display_as_report => 'WITHOUT_MODIFICATION',
  p_aggregate_by => 'N',
  p_required => 'Y',
  p_alignment => 'R',
  p_display_width => 30,
  p_max_width => 22,
  p_height => 1,
  p_group_by => 'N',
  p_searchable => 'N',
  p_column_id => 58882542512898804799 + wwv_flow_api.g_id_offset,
  p_table_id => 58882542420124804798 + wwv_flow_api.g_id_offset,
  p_column_name => 'ID');
 
end;
/

commit;
begin 
execute immediate 'alter session set nls_numeric_characters='''||wwv_flow_api.g_nls_numeric_chars||'''';
end;
/
set verify on
set feedback on
prompt  ...done
