CREATE OR REPLACE PACKAGE  "INDICATORS" 
AUTHID definer
IS
   SUBTYPE tsRSLT IS VARCHAR2(32767);
   TYPE ttVECTOR IS TABLE OF NUMBER INDEX BY PLS_INTEGER;
   TYPE ttMATRIX IS TABLE OF ttVECTOR INDEX BY PLS_INTEGER;
   cnPOLY CONSTANT PLS_INTEGER:=1; 
   cnLINE CONSTANT PLS_INTEGER:=2; 
   cnEXP  CONSTANT PLS_INTEGER:=3; 
   cnLN   CONSTANT PLS_INTEGER:=4; 
   cnPWR  CONSTANT PLS_INTEGER:=5; 
   cnHPRB CONSTANT PLS_INTEGER:=6; 
   FUNCTION fnPOLY RETURN NUMBER deterministic;
   FUNCTION fnLINE RETURN NUMBER deterministic;
   FUNCTION fnEXP  RETURN NUMBER deterministic;
   FUNCTION fnLN   RETURN NUMBER deterministic;
   FUNCTION fnPWR  RETURN NUMBER deterministic;
   FUNCTION fnHPRB RETURN NUMBER deterministic;
   FUNCTION SMA (vector IN ttVECTOR,
                period IN NUMBER
                 ) RETURN ttVECTOR;
   FUNCTION EMA(vector IN ttVECTOR,
                period IN NUMBER
                ) RETURN ttVECTOR;
   FUNCTION PO(vctrCLOSE IN ttVECTOR,
               periodS IN NUMBER,
               periodL IN NUMBER
               ) RETURN ttVECTOR;
   
   FUNCTION MOMENTUM(vctrCLOSE IN ttVECTOR,
                     period IN NUMBER
                     ) RETURN ttVECTOR;  
   FUNCTION RSI(vctrCLOSE IN ttVECTOR,
                 buy IN OUT ttVECTOR,
                 sell IN OUT ttVECTOR,
                 period IN NUMBER
                 ) RETURN ttVECTOR;
 
   FUNCTION Parabolic_SAR(HIGH IN ttVECTOR,
                           LOW IN ttVECTOR
                           ) RETURN ttVECTOR;  
 
   FUNCTION Bollinger_Bands(vctrCLOSE IN ttVECTOR,
                            period IN NUMBER
                            ) RETURN ttVECTOR;  
   FUNCTION MACD(vctrCLOSE IN ttVECTOR,
                 periodS IN NUMBER,
                 periodL IN NUMBER
                 ) RETURN ttVECTOR;
   FUNCTION STOCHASTIC(vctrCLOSE IN ttVECTOR,
                       HIGH IN ttVECTOR,
                       LOW IN ttVECTOR,
                       period IN NUMBER
                       ) RETURN ttVECTOR;   
   FUNCTION STR_VECTOR(ptVECTOR IN ttVECTOR, 
                       pnROUND  IN NUMBER:=2 -- -    
                        ) RETURN VARCHAR2;  
   FUNCTION STR_MATRIX(ptMATRIX IN ttMATRIX, 
                       pnROUND  IN NUMBER:=2 
                      ) RETURN VARCHAR2;
   PROCEDURE LN_VECTOR(ptVECTOR IN OUT NOCOPY ttVECTOR);
   PROCEDURE INV_VECTOR(ptVECTOR IN OUT NOCOPY ttVECTOR);

   FUNCTION GAUSS(ptMTRX IN OUT NOCOPY ttMATRIX) RETURN ttVECTOR;
   --       -
   FUNCTION GRAM(ptARG  IN OUT NOCOPY ttVECTOR, 
                 ptVAL  IN OUT NOCOPY ttVECTOR, 
                 pnBASE IN            NUMBER:=0 
                ) RETURN ttMATRIX;
   FUNCTION GET_FUNC_VAL(pnTYPE IN            NUMBER,  
                         pnARG  IN            NUMBER,  
                         ptRATE IN OUT NOCOPY ttVECTOR 
                        ) RETURN NUMBER;
 
   PROCEDURE FUNC(pnTYPE IN            NUMBER,   
                  ptRATE IN OUT NOCOPY ttVECTOR, 
                  pnMIN  IN            NUMBER,   
                  pnMAX  IN            NUMBER,   
                  pnSTEP IN            NUMBER,   
                  ptARG  OUT           ttVECTOR, 
                  ptVAL  OUT           ttVECTOR  
                 );

  FUNCTION APRX_DEGR_POLY(ptARG  IN OUT NOCOPY ttVECTOR, --    -
                           ptVAL  IN OUT NOCOPY ttVECTOR, --    -
                           pnBASE IN            NUMBER    --   
                          ) RETURN ttVECTOR;

  FUNCTION APRX_LINE(ptARG IN OUT NOCOPY ttVECTOR,--    -
                      ptVAL IN OUT NOCOPY ttVECTOR --    -
                     ) RETURN ttVECTOR;

  FUNCTION APRX_EXP(ptARG IN OUT NOCOPY ttVECTOR,--    -
                     ptVAL IN OUT NOCOPY ttVECTOR --    -
                    ) RETURN ttVECTOR;

   FUNCTION APRX_LN(ptARG IN OUT NOCOPY ttVECTOR,--    -
                    ptVAL IN OUT NOCOPY ttVECTOR --    -
                   ) RETURN ttVECTOR;

   FUNCTION APRX_PWR(ptARG IN OUT NOCOPY ttVECTOR,
                     ptVAL IN OUT NOCOPY ttVECTOR 
                    ) RETURN ttVECTOR;

   FUNCTION APRX_HPRB(ptARG IN OUT NOCOPY ttVECTOR,
                      ptVAL IN OUT NOCOPY ttVECTOR 
                     ) RETURN ttVECTOR;

   PROCEDURE FUNC_LINE(pnX1   IN             NUMBER,  
                       pnY1   IN             NUMBER,  
                       pnX2   IN             NUMBER,  
                       pnY2   IN             NUMBER,  
                       ptVAL  IN OUT NOCOPY ttVECTOR, 
                       pnSTEP IN            NUMBER:=1 
                      );
END APRX;
/
CREATE OR REPLACE PACKAGE BODY  "INDICATORS" 
IS
   FUNCTION fnPOLY RETURN NUMBER IS BEGIN RETURN cnPOLY; END;
   FUNCTION fnLINE RETURN NUMBER IS BEGIN RETURN cnLINE; END;
   FUNCTION fnEXP  RETURN NUMBER IS BEGIN RETURN cnEXP;  END;
   FUNCTION fnLN   RETURN NUMBER IS BEGIN RETURN cnLN;   END;
   FUNCTION fnPWR  RETURN NUMBER IS BEGIN RETURN cnPWR;  END;
   FUNCTION fnHPRB RETURN NUMBER IS BEGIN RETURN cnHPRB; END;   
   FUNCTION SMA(vector IN ttVECTOR,
                period IN NUMBER
               ) RETURN ttVECTOR
   IS
      ltVCTR ttVECTOR; 
      vctr NUMBER;
      n NUMBER;
      x NUMBER;
      i NUMBER;
   BEGIN
       n:= vector.count-period-1;
       vctr:=0;
         FOR i IN 0..n
           LOOP
             FOR x IN 0..(period-1)
               LOOP
            vctr:=vctr+vector(i+x);
             END LOOP; 
           vctr:=vctr/period;
           ltVCTR(i+period):=vctr;
         vctr:=0;
      END LOOP; 
     RETURN  ltVCTR;
   END SMA;
   
   FUNCTION EMA(vector IN ttVECTOR,
                period IN NUMBER
               ) RETURN ttVECTOR
   IS
      ltVCTR ttVECTOR; 
      vctr NUMBER;
      n NUMBER;
      x NUMBER;
      i NUMBER;
      k NUMBER;
      m NUMBER;
   BEGIN
       n:= vector.count-period-1;
       k:=2/(period+1);
       vctr:=0;
       FOR m IN 0..(period-1)
           LOOP
            vctr:=vctr+vector(m);
           END LOOP;
       ltVCTR(period-1):=vctr/period;
       vctr:=0;
       FOR i IN 0..n
         LOOP
         ltVCTR(i+period):=ltVCTR(i+period-1)*(1-k)+k*vector(i+period-1);
         vctr:=0;
      END LOOP; 
     RETURN  ltVCTR;
   END EMA;
   FUNCTION PO(vctrCLOSE IN ttVECTOR,
               periodS IN NUMBER,
               periodL IN NUMBER
                ) RETURN ttVECTOR
   IS
      ltVCTR ttVECTOR; 
      pS NUMBER;
      pL NUMBER;
      MAs ttVECTOR;
      MAl ttVECTOR;
      n NUMBER;
      x NUMBER;
      i NUMBER;
      c NUMBER;
   BEGIN
      n:= vctrCLOSE.count-1;
      MAs:=SMA(vctrCLOSE, periodS);
      MAl:=SMA(vctrCLOSE, periodL);
      FOR i IN periodL..n
      LOOP
       ltVCTR(i):=MAs(i)-MAl(i); 
      END LOOP; 
     RETURN  ltVCTR;
   END PO;
   FUNCTION MOMENTUM(vctrCLOSE IN ttVECTOR,
                      period IN NUMBER
                     ) RETURN ttVECTOR
    IS
      ltVCTR ttVECTOR;
      n NUMBER;
    BEGIN
      n:=vctrCLOSE.count-period-1;
      FOR i IN 0..n
         LOOP
         ltVCTR(period+i):=vctrCLOSE(i+period)/vctrCLOSE(i)*100 ;
      END LOOP;
     RETURN  ltVCTR;
    END MOMENTUM;
    FUNCTION RSI(vctrCLOSE IN ttVECTOR,
                 buy IN OUT ttVECTOR,
                 sell IN OUT ttVECTOR,
                 period IN NUMBER
                ) RETURN ttVECTOR
    IS
      ltVCTR ttVECTOR; 
      CU NUMBER;
      CD NUMBER;
      RS NUMBER;
      n NUMBER;
      x NUMBER;
      i NUMBER;
      y NUMBER;
      z NUMBER;
    BEGIN
        n:= vctrCLOSE.count-period-1;
        CU:=0;
        CD:=0;
        y:=0;
        z:=0;
         FOR i IN 0..n
         LOOP
             FOR x IN 1..(period-1)
            LOOP
             IF   vctrCLOSE(i+x)>= vctrCLOSE(i+x-1) THEN 
              CU:=CU+vctrCLOSE(i+x);
             ELSE
              CD:=CD+vctrCLOSE(i+x); 
            END IF;
            END LOOP;
          IF CD=0 THEN
               ltVCTR(i):=100;
          ELSE RS:=CU/CD;
          ltVCTR(i+period):=100-(100/(1+RS));
          END IF; 
          CU:=0;
          CD:=0; 
        END LOOP;
        FOR i IN 1..n LOOP
         IF 70<ltVCTR(i+period-1) AND ltVCTR(i+period)<=70 THEN
            sell(y):=vctrCLOSE(i+period);
            y:=y+1;
          END IF;
          IF   ltVCTR(i+period-1)<30 AND ltVCTR(i+period)>=30 THEN
            buy(z):=vctrCLOSE(i+period);
            z:=z+1;
          END IF;
       END LOOP; 
     RETURN  ltVCTR;
  END RSI;     
  FUNCTION Parabolic_SAR(HIGH IN ttVECTOR,
                         LOW IN ttVECTOR
                         ) RETURN ttVECTOR
    IS
      ltVCTR ttVECTOR;   
      SAR ttVECTOR; 
      K NUMBER;
      n NUMBER;
      EXTR NUMBER;
i NUMBER;
Z NUMBER;
    BEGIN
      n:= HIGH.count;
K:=0.02;
Z:=0;
      IF HIGH(0)>HIGH(1) THEN 
        SAR(0):=HIGH(0);
        SAR(1):=SAR(0)+K*(LOW(0)-SAR(0));
        EXTR:=LOW(1);
       ELSE SAR(0):=LOW(0);
        SAR(1):=SAR(0)+K*(HIGH(0)-SAR(0));
        EXTR:=HIGH(1);
      END IF;
      ltVCTR(0):=SAR(0);
      ltVCTR(1):=SAR(1); 
      SAR(2):=SAR(1)+K*(EXTR-SAR(1));
     FOR i IN 1..(n-2)
         LOOP
        IF Z=1 AND SAR(i)>SAR(i-1) THEN          
         EXTR:=LOW(i);
         Z:=0;
          IF LOW(i)<LOW(i-1) AND K<0.3 THEN K:=K*2;
          END IF; 
        ELSIF Z=1 AND SAR(i)<SAR(i-1) THEN      
            EXTR:=HIGH(i);
            Z:=0;
        IF HIGH(i)>HIGH(i-1) AND K<0.3 THEN K:=K*2;
        END IF;
      ELSIF (SAR(i)>SAR(i-1)) AND (SAR(i)<=LOW(i)) THEN
        EXTR:=HIGH(i);
        IF HIGH(i)>HIGH(i-1) AND K<0.3 THEN K:=K*2;
        END IF;
      ELSIF (SAR(i)>SAR(i-1)) AND (SAR(i)>LOW(i)) THEN
         EXTR:=LOW(i);
         SAR(i):=HIGH(i);
K:=0.02;
Z:=1;
      ELSIF SAR(i)<SAR(i-1) AND (SAR(i)>=HIGH(i))  THEN
          EXTR:=LOW(i);
          IF LOW(i)<LOW(i-1) AND K<0.3 THEN K:=K*2;
          END IF;
      ELSIF SAR(i)<SAR(i-1) AND SAR(i)<HIGH(i)  THEN
         EXTR:=HIGH(i);
         SAR(i):=LOW(i);
K:=0.02;
Z:=1;
       ELSE ltVCTR(i):=0;
       END IF; 
      SAR(i+1):=SAR(i)+K*(EXTR-SAR(i));
      ltVCTR(i+1):=SAR(i+1);
     END LOOP;
   RETURN  ltVCTR;
END Parabolic_SAR;
 
   FUNCTION Bollinger_Bands(vctrCLOSE IN ttVECTOR,
                            period IN NUMBER
                            ) RETURN ttVECTOR
    IS
      DEV ttVECTOR; 
      ML ttVECTOR; 
      Z NUMBER; 
      n NUMBER;
      x NUMBER;
      i NUMBER;
    BEGIN
        n:= vctrCLOSE.count-1-2*period;
        ML:=SMA(vctrCLOSE,period);
        z:=0;
         FOR i IN 0..n
         LOOP
           FOR x IN 0..(period-1)
            LOOP
             z:=z+(vctrCLOSE(i+period)-ML(i+period+x))* (vctrCLOSE(i+period)-ML(i+period+x));
            END LOOP;
            z:=z/period;
            Dev(i+2*period):=SQRT(z);
            z:=0; 
         END LOOP; 
     RETURN  DEV;
    END Bollinger_Bands;
    FUNCTION MACD(vctrCLOSE IN ttVECTOR,
                 periodS IN NUMBER,
                 periodL IN NUMBER
                ) RETURN ttVECTOR
   IS
      ltVCTR ttVECTOR; 
      EMAs ttVECTOR;
      EMAl ttVECTOR;
      n NUMBER;
      i NUMBER;
      c NUMBER;
   BEGIN
      c:=periodL-periodS;
      n:= vctrCLOSE.count-1;
      EMAl:=EMA(vctrCLOSE,periodL);
      EMAs:=EMA(vctrCLOSE,periodS);
      FOR i IN 0..n-periodL 
        LOOP
          ltVCTR(i):=EMAl(i+periodL)-EMAs(i+periodL);
        END LOOP;
     RETURN  ltVCTR;
   END MACD;
   FUNCTION STOCHASTIC(vctrCLOSE IN ttVECTOR,
                       HIGH IN ttVECTOR,
                       LOW IN ttVECTOR,
                       period IN NUMBER
                      ) RETURN ttVECTOR
    IS
      FST  ttVECTOR;
      maxV NUMBER;
      minV NUMBER;
      n NUMBER;
      i NUMBER;
      x NUMBER;
    BEGIN
        n:=vctrCLOSE.count-period-1;       
        maxV:= HIGH(0);
        minV:= LOW(0); 
      FOR i IN 0..n
          LOOP            
            FOR x in 1..(period-1) 
             LOOP
              IF maxV<HIGH(x+i) THEN maxV:=HIGH(x+i);
              END IF;
              IF minV>LOW(x+i) THEN minV:=LOW(x+i);
              END IF;
             END LOOP;      
           FST(i):=100*(vctrCLOSE(i+period-1)-minV)/(maxV-minV);
           maxV:= HIGH(i+1);
           minV:= LOW(i+1);
        END LOOP;   
     RETURN  FST;
    END  STOCHASTIC; 
   FUNCTION STR_VECTOR(ptVECTOR IN ttVECTOR, --   
                       pnROUND  IN NUMBER:=2 -- -    
                      ) RETURN VARCHAR2
   IS
     lsRSLT tsRSLT;
     i NUMBER;
   BEGIN
     i:=ptVECTOR.FIRST;
     WHILE i IS NOT NULL
     LOOP
       lsRSLT:=lsRSLT||round(ptVECTOR(i),pnROUND);
       IF i!=ptVECTOR.LAST
       THEN
         lsRSLT:=lsRSLT||'; ';
       END IF;
       i:=ptVECTOR.next(i);
     END LOOP;
     RETURN lsRSLT;
   END STR_VECTOR;
   FUNCTION STR_MATRIX(ptMATRIX IN ttMATRIX, --   
                       pnROUND  IN NUMBER:=2 -- -    
                      ) RETURN VARCHAR2
   IS
     lsRSLT tsRSLT;
     i NUMBER;
     j NUMBER;
   BEGIN
     i:=ptMATRIX.FIRST;
     WHILE i IS NOT NULL
     LOOP
       j:=ptMATRIX(i).FIRST;
       WHILE j IS NOT NULL
       LOOP
         lsRSLT:=lsRSLT||round(ptMATRIX(i)(j),pnROUND);
         IF j!=ptMATRIX(i).LAST
         THEN
           lsRSLT:=lsRSLT||'; ';
         END IF;
         j:=ptMATRIX(i).next(j);
       END LOOP;
       IF i!=ptMATRIX.LAST
       THEN
         lsRSLT:=lsRSLT||chr(10);
       END IF;
       i:=ptMATRIX.next(i);
     END LOOP;
     RETURN lsRSLT;
   END STR_MATRIX;
   PROCEDURE LN_VECTOR(ptVECTOR IN OUT NOCOPY ttVECTOR)
   IS
   BEGIN
     FOR i IN ptVECTOR.FIRST..ptVECTOR.LAST
     LOOP
       IF ptVECTOR(i)!=0
       THEN
         ptVECTOR(i):=LN(ptVECTOR(i));
       END IF;
     END LOOP;
   END LN_VECTOR;
   PROCEDURE INV_VECTOR(ptVECTOR IN OUT NOCOPY ttVECTOR)
   IS
   BEGIN
     FOR i IN ptVECTOR.FIRST..ptVECTOR.LAST
     LOOP
       IF ptVECTOR(i)!=0
       THEN
         ptVECTOR(i):=1/ptVECTOR(i);
       END IF;
     END LOOP;
   END INV_VECTOR;
   FUNCTION GAUSS(ptMTRX IN OUT NOCOPY ttMATRIX) RETURN ttVECTOR
   IS
     ltVCTR ttVECTOR;
     i PLS_INTEGER;
     j PLS_INTEGER;
     n PLS_INTEGER;
     n1 PLS_INTEGER;
     k1 PLS_INTEGER;
     s NUMBER;
     r NUMBER;
   BEGIN
     n:=ptMTRX.count-1;
     FOR i IN 0..n
     LOOP
       ltVCTR(i):=0;
     END LOOP;
     n1:=n+1;
     FOR k IN 0..n
     LOOP
       k1:=k+1;
       s:=ptMTRX(k)(k);
       FOR j IN k1..n1
       LOOP
         BEGIN
           ptMTRX(k)(j):=ptMTRX(k)(j)/s;
         EXCEPTION
           WHEN NO_DATA_FOUND
             THEN
               ptMTRX(k)(j):=0;
         END;
       END LOOP;
       FOR i IN k1..n
       LOOP
         r:=ptMTRX(i)(k);
         FOR j IN k1..n1
         LOOP
           ptMTRX(i)(j):=ptMTRX(i)(j)-ptMTRX(k)(j)*r;
         END LOOP;
       END LOOP;
     END LOOP;
     FOR i IN REVERSE 0..n
     LOOP
       s:=ptMTRX(i)(n1);
       FOR j IN i+1..n
       LOOP
         s:=s-ptMTRX(i)(j)*ltVCTR(j);
       END LOOP;
       ltVCTR(i):=s;
     END LOOP;
     RETURN ltVCTR;
   EXCEPTION
     WHEN NO_DATA_FOUND
       THEN
         ltVCTR.DELETE;
         RETURN ltVCTR;
     WHEN OTHERS
       THEN
         raise_application_error(-20100,'APRX.GAUSS: '||sqlerrm);
   END GAUSS;
   FUNCTION GRAM(ptARG  IN OUT NOCOPY ttVECTOR, --    -
                 ptVAL  IN OUT NOCOPY ttVECTOR, --    -
                 pnBASE IN            NUMBER:=0 --  
                ) RETURN ttMATRIX
   IS
     ltMTRX ttMATRIX;
     n PLS_INTEGER;
     i PLS_INTEGER;
     j PLS_INTEGER;
     p NUMBER;
     q NUMBER;
     r NUMBER;
     s NUMBER;
   BEGIN
     n:=ptARG.count-1;
     FOR j IN 0..pnBASE
     LOOP
       s:=0;
       r:=s;
       q:=s;
       FOR i IN 0..n
       LOOP
         p:=POWER(ptARG(i),j);
         s:=s+p;
         r:=r+p*ptVAL(i);
         q:=q+p*POWER(ptARG(i),pnBASE);
       END LOOP;
       ltMTRX(0)(j):=s;
       ltMTRX(j)(pnBASE+1):=r;
       ltMTRX(j)(pnBASE):=q;
     END LOOP;
     
     FOR i IN 1..pnBASE
     LOOP
       FOR j IN 0..pnBASE-1
       LOOP
         ltMTRX(i)(j):=ltMTRX(i-1)(j+1);
       END LOOP;
     END LOOP;
     RETURN ltMTRX;
   END GRAM;
   FUNCTION GET_FUNC_VAL(pnTYPE IN            NUMBER,  
                         pnARG  IN            NUMBER,  
                         ptRATE IN OUT NOCOPY ttVECTOR 
                        ) RETURN NUMBER
   IS
     lnVAL NUMBER;
   BEGIN
     lnVAL:=0;
     CASE pnTYPE
       WHEN cnPOLY
         THEN
           FOR i IN ptRATE.FIRST..ptRATE.LAST
           LOOP
             lnVAL:=lnVAL+POWER(pnARG,i)*ptRATE(i);
           END LOOP;
       WHEN cnLINE
         THEN
           lnVAL:=ptRATE(0)+ptRATE(1)*pnARG;
       WHEN cnEXP
         THEN
           lnVAL:=ptRATE(0)*EXP(ptRATE(1)*pnARG);
       WHEN cnLN
         THEN
           lnVAL:=ptRATE(0)+ptRATE(1)*LN(pnARG);
       WHEN cnPWR
         THEN
           lnVAL:=ptRATE(0)*POWER(pnARG,ptRATE(1));
       WHEN cnHPRB
         THEN
           lnVAL:=ptRATE(0)+ptRATE(1)/pnARG;
     END CASE;
     RETURN lnVAL;
   EXCEPTION
     WHEN OTHERS
       THEN
         raise_application_error(-20090,'APRX.GET_FUNC_VAL: '||sqlerrm);
   END GET_FUNC_VAL;
   PROCEDURE FUNC(pnTYPE IN            NUMBER,   
                  ptRATE IN OUT NOCOPY ttVECTOR, 
                  pnMIN  IN            NUMBER,   
                  pnMAX  IN            NUMBER,   
                  pnSTEP IN            NUMBER,   
                  ptARG  OUT           ttVECTOR, 
                  ptVAL  OUT           ttVECTOR  
                 )
   IS
     lnARG NUMBER;
     lnBASE PLS_INTEGER;
     --     
     PROCEDURE CALC_VAL
     IS
     BEGIN
       ptARG(ptARG.COUNT+1):=lnARG;
       ptVAL(ptVAL.COUNT+1):=GET_FUNC_VAL(pnTYPE,lnARG,ptRATE);
     END CALC_VAL;
   BEGIN
     ptARG.DELETE;
     ptVAL.DELETE;
     IF ptRATE.COUNT=0
     THEN
       raise_application_error(-20090,'No rate vector');
     END IF;
     lnBASE:=ptRATE.count-1;
     lnARG:=pnMIN;
     LOOP
       IF lnARG>=pnMAX
       THEN
         lnARG:=pnMAX;
         CALC_VAL;
         EXIT;
       END IF;
       CALC_VAL;
       lnARG:=lnARG+pnSTEP;
     END LOOP;
   EXCEPTION
     WHEN OTHERS
       THEN
         raise_application_error(-20100,'APRX.FUNC: '||sqlerrm);
   END FUNC;
   FUNCTION APRX_DEGR_POLY(ptARG  IN OUT NOCOPY ttVECTOR, 
                           ptVAL  IN OUT NOCOPY ttVECTOR, 
                           pnBASE IN            NUMBER    
                          ) RETURN ttVECTOR
   IS
     ltMTRX ttMATRIX;
     ltVCTR ttVECTOR;
   BEGIN
     --   
     ltMTRX:=GRAM(ptARG,ptVAL,pnBASE);
     --  
     ltVCTR:=GAUSS(ltMTRX);
     RETURN ltVCTR;
   EXCEPTION
     WHEN OTHERS
       THEN
         raise_application_error(-20100,'APRX.APRX_DEGR_POLY: '||sqlerrm);
   END APRX_DEGR_POLY;
   FUNCTION APRX_LINE(ptARG IN OUT NOCOPY ttVECTOR,
                      ptVAL IN OUT NOCOPY ttVECTOR 
                     ) RETURN ttVECTOR
   IS
     ltMTRX ttMATRIX;
     ltVCTR ttVECTOR;
   BEGIN
     --   
     ltMTRX:=GRAM(ptARG,ptVAL,1);
     --  
     ltVCTR:=GAUSS(ltMTRX);
     RETURN ltVCTR;
   EXCEPTION
     WHEN OTHERS
       THEN
         raise_application_error(-20100,'APRX.APRX_LINE: '||sqlerrm);
   END APRX_LINE;
   FUNCTION APRX_EXP(ptARG IN OUT NOCOPY ttVECTOR,
                     ptVAL IN OUT NOCOPY ttVECTOR 
                    ) RETURN ttVECTOR
   IS
     ltMTRX ttMATRIX;
     ltVCTR ttVECTOR;
   BEGIN
     --    -
     LN_VECTOR(ptVAL);
     --   
     ltMTRX:=GRAM(ptARG,ptVAL,1);
     --  
     ltVCTR:=GAUSS(ltMTRX);
     IF ltVCTR.count>0
     THEN --   a0
       ltVCTR(0):=EXP(ltVCTR(0));
     END IF;
     RETURN ltVCTR;
   EXCEPTION
     WHEN OTHERS
       THEN
         raise_application_error(-20100,'APRX.APRX_EXP: '||sqlerrm);
   END APRX_EXP;
   FUNCTION APRX_LN(ptARG IN OUT NOCOPY ttVECTOR,
                    ptVAL IN OUT NOCOPY ttVECTOR 
                   ) RETURN ttVECTOR
   IS
     ltMTRX ttMATRIX;
     ltVCTR ttVECTOR;
   BEGIN
     --    -
     LN_VECTOR(ptARG);
     --   
     ltMTRX:=GRAM(ptARG,ptVAL,1);
     --  
     ltVCTR:=GAUSS(ltMTRX);
     RETURN ltVCTR;
   END APRX_LN;
   FUNCTION APRX_PWR(ptARG IN OUT NOCOPY ttVECTOR,
                     ptVAL IN OUT NOCOPY ttVECTOR 
                    ) RETURN ttVECTOR
   IS
     ltMTRX ttMATRIX;
     ltVCTR ttVECTOR;
   BEGIN
     --    -
     LN_VECTOR(ptARG);
     --    -
     LN_VECTOR(ptVAL);
     --   
     ltMTRX:=GRAM(ptARG,ptVAL,1);
     --  
     ltVCTR:=GAUSS(ltMTRX);
     IF ltVCTR.count>0
     THEN --   a0
       ltVCTR(0):=EXP(ltVCTR(0));
     END IF;
     RETURN ltVCTR;
   EXCEPTION
     WHEN OTHERS
       THEN
         raise_application_error(-20100,'APRX.APRX_PWR: '||sqlerrm);
   END APRX_PWR;
   FUNCTION APRX_HPRB(ptARG IN OUT NOCOPY ttVECTOR,
                      ptVAL IN OUT NOCOPY ttVECTOR 
                     ) RETURN ttVECTOR
   IS
     ltMTRX ttMATRIX;
     ltVCTR ttVECTOR;
   BEGIN
     --    -
     INV_VECTOR(ptARG);
     --   
     ltMTRX:=GRAM(ptARG,ptVAL,1);
     --  
     ltVCTR:=GAUSS(ltMTRX);
     RETURN ltVCTR;
   EXCEPTION
     WHEN OTHERS
       THEN
         raise_application_error(-20100,'APRX.APRX_HPRB: '||sqlerrm);
   END APRX_HPRB;
   PROCEDURE FUNC_LINE(pnX1   IN             NUMBER,  
                       pnY1   IN             NUMBER,  
                       pnX2   IN             NUMBER,  
                       pnY2   IN             NUMBER,  
                       ptVAL  IN OUT NOCOPY ttVECTOR, 
                       pnSTEP IN            NUMBER:=1 
                      )
   IS
     ltRATE ttVECTOR;
     ltARG  ttVECTOR;
     ltVAL  ttVECTOR;
   BEGIN
     ptVAL.DELETE;
     ltARG(0):=pnX1;
     ltARG(1):=pnX2;
     ltVAL(0):=pnY1;
     ltVAL(1):=pnY2;
     ltRATE:=APRX_LINE(ltARG,ltVAL);
     FUNC(cnLINE,
          ltRATE,
          pnX1,
          pnX2,
          pnSTEP,
          ltARG,
          ltVAL
         );
     FOR i IN ltARG.FIRST..ltARG.LAST
     LOOP
       ptVAL(ltARG(i)):=ltVAL(i);
     END LOOP;
   END FUNC_LINE;
END APRX;
/
/
 