﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using System.Data.SqlClient;
using System.Text;

namespace TveMA.FStorage.Core
{
    public interface ICore
    {
        DataTable search(string data, string name, string extent, string categ, string tags, string meta);
        DataTable search(string name, string extent, string categ, string tags, string meta);
        DataTable searchAll();
        int update(string fileAddress);
        int update(Guid fileId);
        int update(string fileAddress, string tags);
        int update(Guid fileId, string tags);
        int delete(string fileAddress);
        int delete(Guid fileId);
        int add(string fileAddress);
        int add(string fileAddress, string tags);
        int open(string fileAddress);
        int open(Guid fileId);
        int notSaveChanges(Guid fileId);
        int notSaveChanges(string fileAddress);
        int notSaveChanges();
        int saveChanges();
        int saveChanges(string fileAddress);
        int saveChanges(Guid fileId);
        int removeFromStorage(string fileAddress, string newAddress);
        int removeFromStorage(Guid fileId, string newAddress);
        DataTable getExtensions();
        DataTable getCategories();
        DataTable getExtentOfCategory(string categName);
        int checkExistOfName(string fullName);
        int checkExistOfName(string name, string extent);
        int checkExistOfName(string fullName, out DataTable result);
        int checkExistOfName(string name, string extent, out DataTable result);
    }
}
