﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Diagnostics;
using System.Configuration;


namespace TveMA.FStorage.Core.Manager
{
    /// <summary>
    /// file manager controls file at file system
    /// </summary>
    class FileManager: ManagerI
    {
        const string _errorFNExist = "File is not exist";
        const string _storageExtension = ".fst";

        public FileManager(DataM data):base(data)
        { }

        public FileManager()
        { }

        /// <summary>
        /// updates file data at storage
        /// </summary>
        /// <param name="cloneName"></param>
        /// <returns></returns>
        public int Save(string cloneName) 
        {
            if (String.IsNullOrEmpty(cloneName))
            {
                ErrorMsg = _errorFNExist;
                return -1;
            }
            string cloneFile = Core.Properties.Settings.Default.tempFld + cloneName;
            byte[] temp = null;
            byte[] temp2 = null;
            try
            {
                if (File.Exists(cloneFile) && File.Exists(DM.FAddr))
                {
                    temp = File.ReadAllBytes(DM.FAddr);
                    temp2 = File.ReadAllBytes(cloneFile);
                    File.Replace(cloneFile, DM.FAddr, null);
                }
                else
                {
                    ErrorMsg = _errorFNExist;
                    return -1;
                }
            }
            catch (IOException ex)
            {
                if (temp != null)
                {
                    using (FileStream fs = new FileStream(DM.FAddr, FileMode.Truncate))
                    {
                        fs.Write(temp, 0, temp.Length);
                    }
                    if (!File.Exists(cloneFile) && temp2 != null)
                    {
                        using (FileStream fs = new FileStream(cloneFile, FileMode.Create))
                        {
                            fs.Write(temp2, 0, temp2.Length);
                        }
                    }
                }
                ErrorMsg = ex.Message;
                Error = -1;
                return -1;
            }       
            return 0; 
        }

        /// <summary>
        /// inserts file to storage 
        /// </summary>
        /// <param name="oldPath"></param>
        /// <returns></returns>
        public int Insert(string oldPath)
        {
            string movedFile = oldPath;
            byte[] temp= null;
            try
            {
                if (File.Exists(DM.FAddr))
                {
                    ErrorMsg = _errorFNExist;
                    return -1;
                }
                if(!Directory.Exists(Properties.Settings.Default.StorageFld))
                {
                    Directory.CreateDirectory(Properties.Settings.Default.StorageFld);
                }
                if (File.Exists(movedFile))
                {
                    temp = File.ReadAllBytes(movedFile);
                    File.Copy(movedFile, DM.FAddr);
                }
                else
                {
                    ErrorMsg = _errorFNExist;
                    return -1;
                }
            }
            catch (IOException ex)
            {
                if (temp != null&&!File.Exists(movedFile))
                {
                    using (FileStream fs = new FileStream(movedFile, FileMode.Create))
                    {
                        fs.Write(temp, 0, temp.Length);
                    }
                }
                Error = -1;
                ErrorMsg = ex.Message;
                return -1;
            } 
            return 0;
        }

        /// <summary>
        /// deletes file
        /// </summary>
        /// <returns></returns>
        public int Delete()
        {
            byte[] temp = null;
            try
            {
                if (File.Exists(DM.FAddr))
                {
                    temp = File.ReadAllBytes(DM.FAddr);
                    Delete(DM.FAddr);
                }
                else
                {
                    ErrorMsg = _errorFNExist;
                    return -1;
                }
            }
            catch (IOException ex)
            {
                if (temp != null && !File.Exists(DM.FAddr))
                {
                    using (FileStream fs = new FileStream(DM.FAddr, FileMode.Create))
                    {
                        fs.Write(temp, 0, temp.Length);
                    }
                }
                Error = -1;
                ErrorMsg = ex.Message;
                return -1;
            }
            return 0;
        }

        public int Delete(string fileAddress)
        {
            File.Delete(fileAddress);
            return 0;
        }

        /// <summary>
        /// deletes clone file of opened file
        /// </summary>
        /// <param name="name">name of clone file</param>
        /// <returns></returns>
        public int DeleteClone(string name)
        {
            string clone = Core.Properties.Settings.Default.tempFld + name;
            try
            {
                File.Delete(clone);
            }
            catch (IOException ex)
            {
                Error = -1;
                ErrorMsg = ex.Message;
                return -1;
            }
            return 0;
        }

        /// <summary>
        /// deletes clones of all opened files
        /// </summary>
        /// <returns></returns>
        public int DeleteClones()
        {
            string[] files = Directory.GetFiles(Core.Properties.Settings.Default.tempFld);
            foreach (string f in files)
                File.Delete(f);
            return 0;
        }

        /// <summary>
        /// opens file
        /// </summary>
        /// <param name="name"></param>
        /// <returns></returns>
        public int open(string name)
        {
            string main = Core.Properties.Settings.Default.StorageFld + DM.Id.ToString()+_storageExtension;
            string clone = Core.Properties.Settings.Default.tempFld+name;
            if (!Directory.Exists(Core.Properties.Settings.Default.tempFld))
            {
                Directory.CreateDirectory(Core.Properties.Settings.Default.tempFld);
            }
            try
            {
                File.Copy(main, clone, true);
                Process pr = Process.Start(clone);
            }
            catch (IOException ex)
            {
                ErrorMsg = ex.Message;
                Error = -1;
                return -1;
            }
            return 0;
        }

        /// <summary>
        /// copies file to new address
        /// </summary>
        /// <param name="newAddress"></param>
        /// <returns></returns>
        public int Copy(string newAddress)
        {
            File.Copy(DM.FAddr,newAddress,true);
            return 0;
        }
    }
}
