﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace TveMA.FStorage
{
    public partial class FSt : Form
    {
        public FSt()
        {
            InitializeComponent();
            this.textBFastSearch.Text = Properties.Settings.Default.queryBuffer;
        }


        private void comboBox1_SelectedIndexChanged_1(object sender, EventArgs e)
        {
            if (cBcreated.SelectedItem == cBcreated.Items[1])
            {
                dataCreated2.Visible = true;
            }
            else
            {
                dataCreated2.Visible = false;
            }
        }

        private void comboBox2_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cBmodif.SelectedItem == cBmodif.Items[1])
            {
                dataModif2.Visible = true;
            }
            else
            {
                dataModif2.Visible = false;
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }

        private void openedFileListToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!this.tabControl1.Controls.Contains(this.OpenedFiles))
                this.tabControl1.Controls.Add(this.OpenedFiles);
            RefreshOpenedList();
            tabControl1.SelectTab(this.OpenedFiles);
        }

        private void bCloseOpenedList_Click(object sender, EventArgs e)
        {
            this.tabControl1.Controls.Remove(this.OpenedFiles);
        }
        private void bCloseSearch_Click(object sender, EventArgs e)
        {
            this.tabControl1.Controls.Remove(this.Search);
        }
        private void bStartSearch_Click(object sender, EventArgs e)
        {
            StartSearch();
        }

        private void StartFastSearch()
        {
            Properties.Settings.Default.queryBuffer = this.textBFastSearch.Text;
            Core.CoreFSt core = new Core.CoreFSt();
            this.dataGridView1.DataSource = core.search(this.textBFastSearch.Text, "", "", "", "", "");
            if (this.dataGridView1.DataSource != null)
            {
                this.dataGridView1.Columns["id"].Visible = false;
                this.dataGridView1.Columns["address"].Visible = false;
                this.tabControl1.SelectedTab = this.Files;
            }
            else MessageBox.Show("error during query search", "Error");
        }

        private void StartSearch()
        {
            Core.CoreFSt core = new Core.CoreFSt();
            string meta = "";
            if (!String.IsNullOrEmpty(this.textBSentence.Text))
            {
                this.dataGridView1.DataSource = core.search(this.textBSentence.Text, this.tBName.Text, (this.Extension.MaskFull) ? "." + this.Extension.Text : ""
            , this.tBcat.Text, this.tBtags.Text, meta);
            }
            else
            {
                this.dataGridView1.DataSource = core.search(this.tBName.Text, (this.Extension.MaskFull) ? "." + this.Extension.Text : ""
            , this.tBcat.Text, this.tBtags.Text, meta);
            }
            if (this.dataGridView1.DataSource != null)
            {
                this.dataGridView1.Columns["id"].Visible = false;
                this.dataGridView1.Columns["address"].Visible = false;
                this.tabControl1.SelectedTab = this.Files;
            }
            else MessageBox.Show("error during search", "Error");
        }

        private void bRefreshOpenedList_Click(object sender, EventArgs e)
        {
            RefreshOpenedList();
        }

        private void RefreshOpenedList()
        {
            Core.CoreFSt core = new Core.CoreFSt();
            this.dGridOpenedList.DataSource = core.getOpenedFiles();
            this.dGridOpenedList.Columns["file_id"].Visible = false;
            this.dGridOpenedList.AutoResizeColumn(0);
        }

        private void searchToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!String.IsNullOrEmpty(textBFastSearch.Text) && tabControl1.SelectedTab != this.Search)
                StartFastSearch();
            else
                StartSearch();
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Dispose();
        }

        private void showAllToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Core.CoreFSt core = new Core.CoreFSt();
            this.dataGridView1.DataSource = core.searchAll();
            this.dataGridView1.Columns["id"].Visible = false;
            this.dataGridView1.Columns["address"].Visible = false;
            this.tabControl1.SelectedTab = this.Files;
        }


        private void openToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (this.dataGridView1.SelectedRows.Count != 0)
            {
                Core.CoreFSt core = new Core.CoreFSt();
                core.open(new Guid(this.dataGridView1.SelectedRows[0].Cells["id"].Value.ToString()));
            }
        }

        private void addNemFileToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!this.tabControl1.Controls.Contains(this.AddFile))
                this.tabControl1.Controls.Add(this.AddFile);
            this.openFileDialog1.ShowDialog();
            this.tBbrowseF.Text = this.openFileDialog1.FileName;
            if (tBbrowseF.Text != "")
                this.tabControl1.SelectedTab = this.AddFile;

        }

        private void fileToolStripMenuItem_Click(object sender, EventArgs e)
        {

        }

        private void bInsert_Click(object sender, EventArgs e)
        {
            int error = 0;
            Core.CoreFSt core = new Core.CoreFSt();
            error = (string.IsNullOrEmpty(this.tBinTags.Text)) ?
                error = core.add(this.tBbrowseF.Text) :
                error = core.add(this.tBbrowseF.Text, this.tBinTags.Text);
            this.tBinTags.Clear();
            if (error >= 0)
                MessageBox.Show("File added successfully");
            else
                MessageBox.Show("Error");
        }

        private void bCloseInsert_Click(object sender, EventArgs e)
        {
            this.tBinTags.Clear();
            this.tBbrowseF.Clear();
            this.tabControl1.Controls.Remove(this.AddFile);
        }

        private void contextMenuStrip2_Opening(object sender, CancelEventArgs e)
        {

        }

        private void openToolStripMenuItem2_Click(object sender, EventArgs e)
        {
            if (this.dGridOpenedList.SelectedRows.Count != 0)
            {
                Core.CoreFSt core = new Core.CoreFSt();
                core.open(new Guid(this.dGridOpenedList.SelectedRows[0].Cells["file_id"].Value.ToString()));
            }
        }

        private void openToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            if (this.dataGridView1.SelectedRows.Count != 0)
            {
                Core.CoreFSt core = new Core.CoreFSt();
                core.open(new Guid(this.dataGridView1.SelectedRows[0].Cells["id"].Value.ToString()));
            }
        }

        private void closeToolStripMenuItem2_Click(object sender, EventArgs e)
        {
            closeOpenedfile();
        }

        private void closeOpenedfile()
        {
            if (this.dGridOpenedList.SelectedRows.Count != 0)
            {
                Core.CoreFSt core = new Core.CoreFSt();
                core.notSaveChanges(new Guid(this.dGridOpenedList.SelectedRows[0].Cells["file_id"].Value.ToString()));
            }
            RefreshOpenedList();
        }

        private void saveToolStripMenuItem_Click(object sender, EventArgs e)
        {
            saveOpenedFile();
        }

        private void saveOpenedFile()
        {
            if (this.dGridOpenedList.SelectedRows.Count != 0)
            {
                Core.CoreFSt core = new Core.CoreFSt();
                core.saveChanges(new Guid(this.dGridOpenedList.SelectedRows[0].Cells["file_id"].Value.ToString()));
            }
        }

        private void deleteToolStripMenuItem_Click(object sender, EventArgs e)
        {
            delete();
        }

        private void delete()
        {
            if (this.dataGridView1.SelectedRows.Count != 0)
            {
                Core.CoreFSt core = new Core.CoreFSt();
                core.delete(new Guid(this.dataGridView1.SelectedRows[0].Cells["id"].Value.ToString()));
            }
        }

        private void Form1_KeyDown(object sender, KeyEventArgs e)
        {

        }

        private void tabControl1_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (tabControl1.Controls.Contains(Search) && tabControl1.SelectedTab == Search)
                if (e.KeyChar == (char)Keys.Enter)
                    StartSearch();
                else if (e.KeyChar == (char)Keys.Escape)
                    this.tabControl1.Controls.Remove(this.Search);
        }

        private void textBFastSearch_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == (char)Keys.Enter)
                if (!String.IsNullOrEmpty(textBFastSearch.Text))
                    StartFastSearch();
        }

        private void advancedSearchToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!this.tabControl1.Controls.Contains(this.Search))
                this.tabControl1.Controls.Add(this.Search);
            this.tabControl1.SelectedTab = this.Search;
        }

        private void bBrowse_Click(object sender, EventArgs e)
        {
            this.openFileDialog1.ShowDialog();
            this.tBbrowseF.Text = this.openFileDialog1.FileName;
        }

        private void saveCloseToolStripMenuItem_Click(object sender, EventArgs e)
        {
            saveOpenedFile();
            closeOpenedfile();
        }

        private void closeToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            closeOpenedfile();
        }

        private void closeAllToolStripMenuItem_Click(object sender, EventArgs e)
        {

        }

        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            Properties.Settings.Default.queryBuffer = this.textBFastSearch.Text;
        }

        private void deleteToolStripMenuItem2_Click(object sender, EventArgs e)
        {
            delete();
        }

        private void changeToolStripMenuItem_Click(object sender, EventArgs e)
        {

        }

        private void removeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //if (this.dataGridView1.SelectedRows.Count != 0)
            //{
            //    this.folderBrowserDialog1.ShowDialog();
            //    if(this.folderBrowserDialog1.SelectedPath!="")
            //    {
            //        Core.CoreFSt core = new Core.CoreFSt();
            //        core.removeFromStorage(new Guid(this.dataGridView1.SelectedRows[0].Cells["id"].Value.ToString()), folderBrowserDialog1.SelectedPath);
            //    }
            //}
        }

        private void deleteToolStripMenuItem1_Click(object sender, EventArgs e)
        {
        }
    }
}
