﻿using System;
using System.Collections.Generic;
using System.Collections;
using System.Linq;
using System.Text;
using Irony.Parsing;
using System.Xml;
using TveMA.SearchQueryAnalyser;


namespace TveMA.FStorage.Core.Searcher
{
    /// <summary>
    /// analyses not parsed data 
    /// </summary>
    class Analyser
    {
        public DataS DataForSearch;
        HashSet<string> notTags;
        HashSet<string> possTags;
        List<object> parserErrors;

        public Analyser(DataS ds)
        {
            notTags = new HashSet<string>();
            possTags = new HashSet<string>();
            parserErrors = new List<object>();
            this.DataForSearch = ds;
        }

        /// <summary>
        /// sets output data with not parsed data
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public int SetData(string data)
        {
            //parse data
            SQParser parser = new SQParser(data);
            parser.Parse();
            if ((parser.GetErrors()).Count != 0)
            {
                DataForSearch = new DataS();
                return -1;
            }
            XmlDocument tree = parser.GetXmlTree();
            //analyse result tree from parser
            TreeAnalyser analyser = new TreeAnalyser(tree);
            if (analyser.AnalyseTree() < 0)
                //error
                return -1;
            //set extension data and tags
            if (analyser.Data[DataKind.Ext].Count>0)
            DataForSearch.Ext = analyser.Data[DataKind.Ext][0];
            DataForSearch.Tags.AddRange(analyser.Data[DataKind.Tag]);
            if (analyser.Data[DataKind.Meta].Count!=0)
            DataForSearch.Meta += analyser.Data[DataKind.Meta];
            if (analyser.Data[DataKind.PossibleTag].Count > 0 || analyser.Data[DataKind.NotTag].Count > 0)
            {
                //name or category
                notTags = new HashSet<string>(analyser.Data[DataKind.NotTag]);
                //name or tag or category
                possTags = new HashSet<string>(analyser.Data[DataKind.PossibleTag]);
                //return 1 we need more information about categoryes to complete analysing
                return 1;
            }
            //analysing is complete
            return 0;
        }

        /// <summary>
        /// check some data is it category or not
        /// </summary>
        /// <param name="categories">list of categories</param>
        public void CheckOnCategory(object[] categories)
        {
            foreach (string notTag in notTags)
            {
                if (categories.Contains((object)notTag))
                    DataForSearch.Categ = notTag;
                else DataForSearch.Name = notTag;
            }
            foreach (string possTag in possTags)
            {
                if (categories.Contains((object)possTag))
                    DataForSearch.Categ = possTag;
                else
                {
                    DataForSearch.Tags.Add(possTag);
                }
            }            
        }
    }
}
