﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace TveMA.FStorage.Core.Manager
{
    /// <summary>
    /// controls file and data int the storage
    /// </summary>
    class Manager
    {
        private Manager() { }

        /// <summary>
        /// chooses by kind what action to do and do it
        /// </summary>
        /// <param name="kind">kind of action</param>
        /// <param name="fileId">file id</param>
        /// <returns></returns>
        public static int Work(int kind, Guid fileId)
        {
            DataM dM = new DataM(fileId);
            if (dM.Suit())
                return Work(kind, dM);
            else
                return -1;
        }

        /// <summary>
        /// chooses by kind what action to do and do it
        /// </summary>
        /// <param name="kind">kind of action</param>
        /// <param name="fadr">file address</param>
        /// <returns></returns>
        public static int Work(int kind, string fAddr)
        {
            DataM dM = new DataM(fAddr);
            if (dM.Suit())
                return Work(kind, dM);
            else
                return -1;
        }

        /// <summary>
        /// chooses by kind what action to do and do it
        /// </summary>
        /// <param name="kind">kind of action</param>
        /// <param name="fileId">file id</param>
        /// <param name="data">search query</param>
        /// <returns></returns>
        public static int Work(int kind, Guid fileId, string data)
        {
            DataM dM = new DataM(fileId, data);
            if (dM.Suit())
                return (kind != (int)Acts.REMOVE) ? Work(kind, dM) : Remove(dM, data);
            else
                return -1;
        }

        /// <summary>
        /// chooses by kind what action to do and do it
        /// </summary>
        /// <param name="kind">kind of action</param>
        /// <param name="fileId">file address</param>
        /// <param name="data">search query</param>
        /// <returns></returns>
        public static int Work(int kind, string fadr, string data)
        {
            DataM dM = new DataM(fadr, data);
            if (dM.Suit())
                return (kind != (int)Acts.REMOVE) ? Work(kind, dM) : Remove(dM, data);
            else
                return -1;
        }

        /// <summary>
        /// chooses by kind what action to do and do it
        /// </summary>
        /// <param name="kind">kind of action</param>
        /// <returns></returns>
        public static int Work(int kind)
        {
            switch (kind)
            {
                case ((int)Acts.CLOSEALL):
                    return CloseAll();
                case ((int)Acts.SAVEALL):
                    return SaveAll();
                default: return -1;
            }
        }

        /// <summary>
        /// chooses by kind what action to do and do it
        /// </summary>
        /// <param name="kind">kind of action</param>
        /// <param name="dM">data to manage</param>
        /// <returns></returns>
        private static int Work(int kind, DataM dM)
        {
            switch (kind)
            {
                case ((int)Acts.INSERT):
                    return Insert(dM);
                case ((int)Acts.UPDATE):
                    return Update(dM);
                case ((int)Acts.DELETE):
                    return Delete(dM);
                case ((int)Acts.OPEN):
                    return Open(dM);
                case ((int)Acts.CLOSE):
                    return Close(dM);
                case ((int)Acts.SAVE):
                    return Save(dM);
                default: return -1;
            }
        }

        /// <summary>
        /// removes file from storage to another place
        /// </summary>
        /// <param name="dM"></param>
        /// <param name="newAddress"></param>
        /// <returns></returns>
        private static int Remove(DataM dM, string newAddress)
        {
            FileManager fManager = new FileManager(dM);
            fManager.Copy(newAddress);
            if (fManager.Error < 0)
                return -1;
            DBManager dManager = new DBManager(dM);
            dManager.Delete();
            if (dManager.Error < 0)
            {
                fManager.Delete(newAddress);
                return -1;
            }
            return fManager.Delete();
        }

        /// <summary>
        /// saves all opened files
        /// </summary>
        /// <returns></returns>
        private static int SaveAll()
        {

            throw new NotImplementedException();
        }

        /// <summary>
        /// saves opened file
        /// </summary>
        /// <param name="dM"></param>
        /// <returns></returns>
        private static int Save(DataM dM)
        {
            DateTime modf = new DateTime();
            DBManager dManager = new DBManager(dM);
            string name;
            if (dManager.GetCloneName(out name) < 0)
                return -1;
            FileInfo f = new FileInfo(Core.Properties.Settings.Default.tempFld + name);
            if (f != null)
            {
                modf = f.LastWriteTime;
            }
            dManager.Save(out name, modf);
            if (dManager.Error < 0 || String.IsNullOrEmpty(name))
                return dManager.Error;
            FileManager fManager = new FileManager(dM);
            return fManager.Save(name);
        }

        /// <summary>
        /// closes all opened files
        /// </summary>
        /// <returns></returns>
        private static int CloseAll()
        {
            DBManager dManager = new DBManager();
            dManager.ClearClonesTable();
            if (dManager.Error < 0)
                return dManager.Error;
            FileManager fManager = new FileManager();
            return fManager.DeleteClones();
        }

        /// <summary>
        /// closes opened file
        /// </summary>
        /// <param name="dM"></param>
        /// <returns></returns>
        private static int Close(DataM dM)
        {
            DBManager dManager = new DBManager(dM);
            string name;
            dManager.DelOneClone(out name);
            if (dManager.Error < 0)
                return dManager.Error;
            FileManager fManager = new FileManager();
            return fManager.DeleteClone(name);
        }

        /// <summary>
        /// opens file
        /// </summary>
        /// <param name="dM"></param>
        /// <returns></returns>
        private static int Open(DataM dM)
        {
            DBManager dManager = new DBManager(dM);
            string name;
            dManager.AddNewClone(out name);
            if (dManager.Error < 0)
                return dManager.Error;
            FileManager fManager = new FileManager(dM);
            return fManager.open(name);
        }

        /// <summary>
        /// inserts file to storage
        /// </summary>
        /// <param name="dM"></param>
        /// <returns></returns>
        private static int Insert(DataM dM)
        {
            string adress = dM.FAddr;
            FileInfo f = new FileInfo(adress);
            DateTime crtd = new DateTime();
            DateTime modf = new DateTime();
            DBManager dManager = new DBManager(dM);
            if (f != null)
            {
                crtd = f.CreationTime;
                modf = f.LastWriteTime;
            }
            dManager.Insert(crtd, modf);
            dM = dManager.getNewData();
            if (dManager.Error < 0)
                return dManager.Error;
            FileManager fManager = new FileManager(dM);
            return fManager.Insert(adress);
        }

        /// <summary>
        /// updates file data in storage
        /// </summary>
        /// <param name="dM"></param>
        /// <returns></returns>
        private static int Update(DataM dM)
        {
            DBManager dManager = new DBManager(dM);
            int res = dManager.Update(dM.FAddr);
            if (dManager.Error < 0)
                return dManager.Error;
            return res;
        }

        /// <summary>
        /// deletes file and its data
        /// </summary>
        /// <param name="dM"></param>
        /// <returns></returns>
        private static int Delete(DataM dM)
        {
            DBManager dManager = new DBManager(dM);
             dManager.Delete();
            if (dManager.Error < 0)
                return dManager.Error;
            FileManager fManager = new FileManager(dM); 
            return fManager.Delete();
        }
    }
}
 
 