using System;
using System.Runtime.Serialization;

namespace HarryBonesSolutions.Performance
{
	/// <summary>
	/// The exception that is thrown when an attempt is made to add an
	/// <see cref="ExecutionTimer"/> object to an <see cref="ExecutionTimerCollection"/> and
	///  the collection already contains an object with the same name.
	/// </summary>
	[Serializable]
	public sealed class NameExistsException : ApplicationException, ISerializable
	{
		private string _name = string.Empty;

		/// <summary>
		/// Initializes a new instance of the <see cref="NameExistsException"/> class.
		/// </summary>
		public NameExistsException() : base(){}

		/// <summary>
		/// Initializes a new instance of the <see cref="NameExistsException"/> 
		/// class with the specified message.
		/// </summary>
		/// <param name="message">The message that explains the reason 
		/// for the exception being thrown.</param>
		public NameExistsException(string message) : base(message){}

		/// <summary>
		/// Initializes a new instance of the <see cref="NameExistsException"/> 
		/// class with the specified message and name.
		/// </summary>
		/// <param name="message">The message that explains the reason 
		/// for the exception being thrown.</param>
		/// <param name="name">The name that was duplicated.</param>
		public NameExistsException(string message, string name) : this(message)
		{
			_name = name;
		}

		// Constructor needed for deserialization.
		private NameExistsException(SerializationInfo info, StreamingContext context) : base (info, context)
		{
			_name = info.GetString("Name");
		}

		/// <summary>
		/// Implements the <see cref="ISerializable"/> interface and sets the 
		/// data needed to serialize the <see cref="NameExistsException"/> object.
		/// </summary>
		/// <param name="info">A <see cref="SerializationInfo"/> object that 
		/// contains the information required to serialize the 
		/// <see cref="NameExistsException"/> instance.</param>
		/// <param name="context">A <see cref="StreamingContext"/> object that 
		/// contains the source and destination of the serialized stream 
		/// associated with the <see cref="NameExistsException"/> instance.</param>
		public override void GetObjectData(SerializationInfo info, StreamingContext context)
		{
			info.AddValue("Name", _name, typeof(string));

			base.GetObjectData (info, context);
		}

		/// <summary>
		/// Gets the name of the <see cref="ExecutionTimer"/> that could not
		/// be added to the collection.
		/// </summary>
		public string Name
		{
			get{ return _name; }
		}

	}
}