using System;
using System.Collections.Generic;
using System.Text;
using MouseAnalyzer.Properties;

namespace MouseAnalyzer.SecurityAlgorithms
{
    class TraitsTreeSecurityAlgorithm : ISecurityAlgorithm
    {
        private TraitsTree _tree;

        public TraitsTreeSecurityAlgorithm()
        {
            _tree = new TraitsTree();
        }

        #region ISecurityAlgorithm Members

        public void LearnVector(double[] vector)
        {
            _tree.AddTraitsVector(vector);
        }

        public double CheckVector(double[] vector)
        {
            return _tree.CheckTraitsVector(vector);
        }

        public void Save(string fileName)
        {
            _tree.Save(fileName);
        }

        public void Load(string fileName)
        {
            _tree = TraitsTree.Load(fileName);
        }

        public string Name
        {
            get { return Resources.TraitsTreeSecurityAlgorithmName; }
        }

        public string Description
        {
            get { throw new Exception("The method or operation is not implemented."); }
        }

        #endregion
    }
}
