using System;
using System.Collections.Generic;
using System.Text;

namespace MouseAnalyzer.MouseTraits
{
    class WheelScrollingMouseTrait : ITrait
    {
        private List<int> _scrollingTimeouts;

        public int ScrollingsCount
        {
            get
            {
                return _scrollingTimeouts.Count;
            }
        }

        public int Duration
        {
            get
            {
                if (_scrollingTimeouts.Count > 0)
                {
                    return _scrollingTimeouts[_scrollingTimeouts.Count - 1] - _scrollingTimeouts[0];
                }
                else
                {
                    return 0;
                }
            }
        }

        public WheelScrollingMouseTrait()
        {
            _scrollingTimeouts = new List<int>();
        }

        public void AddNextScrollingTime(int relativeTime)
        {
            _scrollingTimeouts.Add(relativeTime);
        }

        #region ITrait Members

        public double[] GenerateTraitVector()
        {
            return new double[]
            {
                ScrollingsCount,
                Duration
            };
        }

        #endregion
    }
}
