using System;
using System.Collections.Generic;
using System.Text;
using MouseAnalyzer.Wrapper;
using System.Timers;
using MouseAnalyzer.MouseTraits;

namespace MouseAnalyzer.Managers
{
    class MouseManager
    {
        #region Constants
        // ,    +  -     
        private const int MovementsPauseMax = 100;
        private const int WheelPauseMax = 100;
        private const int DoubleClickPauseMax = 100;
        private const int LeftClickPauseMax = 100;
        private const int RightClickPauseMax = 100;
        #endregion

        private MouseHooksWrapper _mouseHooksWrapper;
        private DateTime _relativeStartTime;
        private int _lastEventRelativeTime;
        private MouseEventType _lastEventType;


        //  
        private MovementMouseTrait _currentTrajectory;
        private WheelScrollingMouseTrait _currentScrolling;

        public MouseManager()
        {
            _currentTrajectory = new MovementMouseTrait();
            _currentScrolling = new WheelScrollingMouseTrait();
            _relativeStartTime = DateTime.Now;
            _mouseHooksWrapper = new MouseHooksWrapper();
            _mouseHooksWrapper.MouseAction += new GlobalMouseEventHandler(AnalyzeMouseEvent);
        }

        public void Start()
        {
            _mouseHooksWrapper.SetGlobalMouseHook();
        }

        public void Stop()
        {
            _mouseHooksWrapper.RemoveGlobalMouseHook();
        }

        private void AnalyzeMouseEvent(object sender, GlobalMouseEventArgs e)
        {
            DateTime currentDateTime = DateTime.Now;
            //   
            int currentEventRelativeTime = (int)(((TimeSpan)(currentDateTime - _relativeStartTime)).TotalMilliseconds) + 1;
            //      
            int lastTwoEventsTimeDifference = currentEventRelativeTime - _lastEventRelativeTime;
            switch (e.EventType)
            {
                case MouseEventType.Move:
                    //      MovementsIntervalTimeMax     - MouseEventType.Move,   
                    if ((_lastEventType == MouseEventType.Move) && (lastTwoEventsTimeDifference < MovementsPauseMax))
                    {
                        _currentTrajectory.AddPoint(currentEventRelativeTime, e.X, e.Y);
                    }
                    // ,      ,   ,     TraitsManager
                    else if ((_lastEventType == MouseEventType.Move) && (lastTwoEventsTimeDifference > MovementsPauseMax))
                    {
                        TraitsManager tm = TraitsManager.GetIntstance();
                        tm.AddNewTrait(_currentTrajectory, MouseTraitType.Movement);
                        _currentTrajectory = new MovementMouseTrait();
                        _currentTrajectory.AddPoint(currentEventRelativeTime, e.X, e.Y);
                    }
                    //      ,   . 
                    else if (_lastEventType == MouseEventType.Wheel)
                    {
                        TraitsManager tm = TraitsManager.GetIntstance();
                        tm.AddNewTrait(_currentScrolling, MouseTraitType.WheelScrolling);
                        _currentScrolling = new WheelScrollingMouseTrait();
                        _currentScrolling.AddNextScrollingTime(currentEventRelativeTime);
                    }

                    break;
                case MouseEventType.LeftButtonDown:
                    //   double-click
                    if (_lastEventType == MouseEventType.LeftButtonUp)
                    {
                        TraitsManager tm = TraitsManager.GetIntstance();
                        tm.AddNewTrait(new DoubleClickMouseTrait(lastTwoEventsTimeDifference), MouseTraitType.DoubleClick);
                    }
                    //  
                    else if (_lastEventType == MouseEventType.Move)
                    {
                        TraitsManager tm = TraitsManager.GetIntstance();
                        tm.AddNewTrait(_currentTrajectory, MouseTraitType.Movement);
                        _currentTrajectory = new MovementMouseTrait();
                    }
                    else if (_lastEventType == MouseEventType.Wheel)
                    {
                        TraitsManager tm = TraitsManager.GetIntstance();
                        tm.AddNewTrait(_currentScrolling, MouseTraitType.WheelScrolling);
                    }

                    break;
                case MouseEventType.LeftButtonUp:
                    if (_lastEventType == MouseEventType.LeftButtonDown)
                    {
                        TraitsManager tm = TraitsManager.GetIntstance();
                        tm.AddNewTrait(new ClickMouseTrait(lastTwoEventsTimeDifference, MouseButton.Left), MouseTraitType.LeftButtonClick);
                    }
                    //  
                    else if (_lastEventType == MouseEventType.Move)
                    {
                        TraitsManager tm = TraitsManager.GetIntstance();
                        tm.AddNewTrait(_currentTrajectory, MouseTraitType.Movement);
                        _currentTrajectory = new MovementMouseTrait();
                    }
                    break;
                case MouseEventType.RightButtonDown:
                    //  
                    if (_lastEventType == MouseEventType.Move)
                    {
                        TraitsManager tm = TraitsManager.GetIntstance();
                        tm.AddNewTrait(_currentTrajectory, MouseTraitType.Movement);
                        _currentTrajectory = new MovementMouseTrait();
                    }
                    // wheel scrolling
                    else if (_lastEventType == MouseEventType.Wheel)
                    {
                        TraitsManager tm = TraitsManager.GetIntstance();
                        tm.AddNewTrait(_currentScrolling, MouseTraitType.WheelScrolling);
                    }
                    break;
                case MouseEventType.RightButtonUp:
                    if (_lastEventType == MouseEventType.RightButtonDown)
                    {
                        TraitsManager tm = TraitsManager.GetIntstance();
                        tm.AddNewTrait(new ClickMouseTrait(lastTwoEventsTimeDifference, MouseButton.Right), MouseTraitType.RightButtonClick);
                    }
                    //  
                    else if (_lastEventType == MouseEventType.Move)
                    {
                        TraitsManager tm = TraitsManager.GetIntstance();
                        tm.AddNewTrait(_currentTrajectory, MouseTraitType.Movement);
                        _currentTrajectory = new MovementMouseTrait();
                    }
                    //    - down/up -  
                    break;
                case MouseEventType.Wheel:
                    if ((_lastEventType == MouseEventType.Wheel) && (lastTwoEventsTimeDifference < WheelPauseMax))
                    {
                        _currentScrolling.AddNextScrollingTime(currentEventRelativeTime);
                    }
                    else
                    {
                        TraitsManager tm = TraitsManager.GetIntstance();
                        tm.AddNewTrait(_currentScrolling, MouseTraitType.WheelScrolling);
                        _currentScrolling = new WheelScrollingMouseTrait();
                        _currentScrolling.AddNextScrollingTime(currentEventRelativeTime);
                    }
                    //     (      ) 
                    break;
                case MouseEventType.MiddleButtonDown:
                    //  
                    if (_lastEventType == MouseEventType.Move)
                    {
                        TraitsManager tm = TraitsManager.GetIntstance();
                        tm.AddNewTrait(_currentTrajectory, MouseTraitType.Movement);
                        _currentTrajectory = new MovementMouseTrait();
                    }
                    // wheel scrolling
                    else if (_lastEventType == MouseEventType.Wheel)
                    {
                        TraitsManager tm = TraitsManager.GetIntstance();
                        tm.AddNewTrait(_currentScrolling, MouseTraitType.WheelScrolling);
                    }
                    break;
                case MouseEventType.MiddleButtonUp:
                    if (_lastEventType == MouseEventType.MiddleButtonDown)
                    {
                        TraitsManager tm = TraitsManager.GetIntstance();
                        tm.AddNewTrait(new ClickMouseTrait(lastTwoEventsTimeDifference, MouseButton.Middle), MouseTraitType.MiddleButtonClick);
                    }
                    //  
                    else if (_lastEventType == MouseEventType.Move)
                    {
                        TraitsManager tm = TraitsManager.GetIntstance();
                        tm.AddNewTrait(_currentTrajectory, MouseTraitType.Movement);
                        _currentTrajectory = new MovementMouseTrait();
                    }
                    break;
            }

            //   
            _lastEventType = e.EventType;
            _lastEventRelativeTime = currentEventRelativeTime;
        }
    }
}
