﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using MouseAnalyzer.Wrapper;
using MouseAnalyzer.Managers;

namespace MouseAnalyzer
{
    public partial class MainForm : Form
    {
        private bool _needToClose;
        private MouseManager _mouseManager;
        private SecurityManager _securityManager;

        public MainForm()
        {
            InitializeComponent();
            _needToClose = false;
        }

        // здесь могут быть исключения, поэтому лучше этот метод не вызывать из конструктора
        public bool InitializeManagers()
        {
            bool result = true;
            try
            {
                _mouseManager = new MouseManager();
                _securityManager = new SecurityManager();
                _securityManager.CheckingResultAvailable += new CheckingResultAvailableEventHandler(securityManagerCheckingResultAvailable);
                TraitsManager.GetIntstance().TraitAdded += new TraitAddedEventHandler(MainForm_TraitAdded);
                _securityManager.LoadAlgorithms();
                _mouseManager.Start();
            }
            catch
            {
                result = false;
            }
            return result;
        }

        void MainForm_TraitAdded(object sender, TraitAddedEventArgs e)
        {
            traitsListBox.Items.Add(e.TraitType.ToString());
        }

        private void securityManagerCheckingResultAvailable(object sender, CheckingResultAvailableEventArgs e)
        {
            resultsListBox.Items.Add(e.AlgorithmName + " (" + e.AlgorithmID + ") - " + e.Result);
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            //if (wr != null)
            //{
            //    wr.Dispose();
            //}
            notifyIcon.Dispose();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            //wr.RemoveGlobalMouseHook();
        }

        private void taskBarContextMenuStrip_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
        {
            if (e.ClickedItem == settingsToolStripMenuItem)
            {
                this.Visible = true;
            }
            else if (e.ClickedItem == exitToolStripMenuItem)
            {
                _needToClose = true;
                Application.Exit();
            }
        }

        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (!_needToClose)
            {
                e.Cancel = true;
                this.Visible = false;
            }
            else
            {
                _mouseManager.Stop();
                _securityManager.SaveAlgorithms();
            }
        }

        private void notifyIcon_DoubleClick(object sender, EventArgs e)
        {
            this.Visible = true;
        }

        private void applyButton_Click(object sender, EventArgs e)
        {
            if (inactiveStateRadioButton.Checked)
            {
                _securityManager.State = SecurityManagerState.Inactive;
            }
            else if (learningStateRadioButton.Checked)
            {
                _securityManager.State = SecurityManagerState.Learning;
            }
            else if (monitoringStateRadioButton.Checked)
            {
                _securityManager.State = SecurityManagerState.Monitoring;
            }
        }

    }
}