﻿using System;
using System.Collections.Generic;
using Uznavayko.NeyronNetwork.UznavaykoNetwork;
using XmlSerialization;

namespace UznavaykoNetwork
{
  /// <summary>
  /// A helper class that reads xmlSample file and
  /// returns it in the right format to use in NeyronNetwork.
  /// </summary>
  public static class XmlDataExposer
  {
    /// <summary>
    /// Gets the samples from xml file with XmlPasswordData.
    /// </summary>
    /// <param name="fileName">File name witch contains 
    /// training samples.</param>
    /// <returns></returns>
    public static IList<UznavaykoSample>
      GetSamples(String fileName, ParameterName nameOfTheOutput)
    {
      var xmlFile = XmlPasswordData.ReadXml(fileName);

      var samples = new List<UznavaykoSample>();

      foreach (var word in xmlFile)
      {
        // 1)First char
        double firstChar = 0;
        // 2)First code
        double firstCode = 0;
        // 3)First KeyPressTime
        double firstCodePressTime = 0;
        // 4)Second char
        double secondChar = 0;
        // 5)Second code
        double secondCode = 0;
        // 6)Second KeyPressTime
        double secondCodePressTime = 0;
        // 7)Time between first and second char
        double milliseconds = 0;
        // 8)Hours of the day.
        double hoursOfTheDay = 0;

        bool isFirstChar = true;
        foreach (var note in word.Notes)
        {
          if (isFirstChar)
          {
            firstChar = note.charCode;
            firstCode = note.characterCode;
            firstCodePressTime = note.pressedTime;
            isFirstChar = false;
          }
          else
          {
            secondChar = note.charCode;
            secondCode = note.characterCode;
            secondCodePressTime = note.pressedTime;
            milliseconds = note.miliseconds;
            break;
          }
        }

        if (word.GetDateTime() != null)
        {
          hoursOfTheDay = word.GetDateTime().TimeOfDay.Hours;
        }

        Dictionary<ParameterName, double> parameters =
        new Dictionary<ParameterName, double>
                {
                  { ParameterName.firstChar,firstChar},
                  { ParameterName.firstCode,firstCode},
                  { ParameterName.firstCodePressTime,firstCodePressTime},
                  { ParameterName.hoursOfTheDay,hoursOfTheDay},
                  { ParameterName.milliseconds,milliseconds},
                  { ParameterName.secondChar,secondChar},
                  { ParameterName.secondCode,secondCode},
                  { ParameterName.secondCodePressTime,secondCodePressTime}
                };
        samples.Add(
          new UznavaykoSample(nameOfTheOutput, parameters));
      }
      return samples;
    }
  }
}
