﻿using System;
using System.Collections.Generic;
using System.Xml.Serialization;

namespace XmlSerialization
{
  /// <summary>
  /// This class works with note collection.
  /// It contains collection of notes and have methods to add, delete and update them.
  /// When we read XML we get Array, we dont like array but we can live with ArrayList.
  /// This class is used to work with Array like with ArrayList.
  /// </summary>
  public sealed class Word : IDisposable
  {
    /// <summary>
    /// collection of notes.
    /// </summary>
    private List<Note> listNotes = new List<Note>();

    [XmlAttribute]
    public Int64 Id;

    [XmlElement]
    public DateTime dateTime { get; set; }

    /// <summary>
    /// Gets or sets the notes array.
    /// </summary>
    /// <value>The notes.</value>
    [XmlArrayAttribute("charInfo")]
    public Note[] notes
    {
      get
      {
        return listNotes.ToArray();
      }
      set
      {
        if (value == null) return;
        Note[] items = value;
        listNotes = new List<Note>(items);
      }
    }

    /// <summary>
    /// Initializes a new instance of the Word class.
    /// </summary>
    internal Word()
    {
    }

    /// <summary>
    /// Initializes a new instance of the Word class.
    /// </summary>
    public Word(Int64 Id, DateTime dateTime, Note[] notes)
    {
      this.Id = Id;
      this.dateTime = dateTime;
      this.notes = notes;
    }

    /// <summary>
    /// Deletes the item.
    /// </summary>
    /// <param name="item">The item.</param>
    internal void DeleteItem(Note item)
    {
      foreach (Note note in listNotes)
      {
        if (note.Id == item.Id)
        {
          listNotes.Remove(note);
          break;
        }
      }
    }

    /// <summary>
    /// Updates the item.
    /// </summary>
    /// <param name="item">The item.</param>
    internal void UpdateItem(Note item)
    {
      foreach (Note note in listNotes)
      {
        if (note.Id == item.Id)
        {
          note.miliseconds = item.miliseconds;
          note.characterCode = item.characterCode;
          note.pressedTime = item.pressedTime;
          break;
        }
      }
    }

    internal IEnumerable<long> GetMillisecods()
    {
      foreach (var note in listNotes)
      {
        yield return note.miliseconds;
      }
    }

    #region IDisposable Members

    public void Dispose()
    {
      if (listNotes != null)
      {
        listNotes.Clear();
      }
    }

    #endregion

  }
}
