﻿using System;
using System.Xml.Serialization;

namespace XmlSerialization
{
  /// <summary>
  /// This class is the representative of XML note, Words char and it's info.
  /// </summary>
  public sealed class Note
  {
    #region XML props

    [XmlText]
    public Int64 miliseconds;

    [XmlAttribute("characterCode")]
    public Int64 characterCode;    

    [XmlAttribute("id")]
    public Int64 Id;

    [XmlAttribute("pressedTime")]
    public Int64 pressedTime;

    [XmlAttribute("charCode")]
    public Int64 charCode;

    #endregion

    /// <summary>
    /// Private constructor, dont use it.
    /// </summary>
    private Note()
    {
    }

    /// <summary>
    /// Initializes a new instance of the <see cref="NoteData"/> class.
    /// </summary>
    /// <param name="miliseconds">The miliseconds.</param>
    /// <param name="characterCode">The character code.</param>
    public Note(Int64 miliseconds,Int64 characterCode)
    {
      this.miliseconds = miliseconds;
      this.characterCode = characterCode;
    }
  }//end class Note
}
