using System.Configuration;


namespace Uznavayko.UznavaykoKeyboard.Service
{
  /// <summary>
  /// The class implements custom configuration section for the UznavaykoService.
  /// The section has attributes: 
  /// LearningMode = true,
  /// NotifyAboutErrors = true
  /// </summary>
  public class UznavaykoServiceConfig : ConfigurationSection
  {
    #region Constant values

    private const bool DefaultLearningMode = true;
    private const bool DefaultNotifyAboutErrors = true;
    private const bool DefaultNeedToSaveInXml = true;
    private const bool DefaultNeedToLearnFromXml = true;
    private const string DefaultServiceName = "UznavaykoService";

    #endregion

    #region Private vars
    private static ConfigurationPropertyCollection properties;

    /// <summary>
    /// The learningMode configuration property.
    /// </summary>
    private static readonly ConfigurationProperty learningMode =
        new ConfigurationProperty("learningMode",
        typeof(bool), DefaultLearningMode,
        ConfigurationPropertyOptions.IsRequired);

    /// <summary>
    /// The notifyAboutErrors configuration property.
    /// </summary>
    private static readonly ConfigurationProperty notifyAboutErrors =
        new ConfigurationProperty("notifyAboutErrors",
        typeof(bool), DefaultNotifyAboutErrors,
        ConfigurationPropertyOptions.IsRequired);

    /// <summary>
    /// The needToSaveInXml configuration property.
    /// </summary>
    private static readonly ConfigurationProperty needToSaveInXml =
        new ConfigurationProperty("needToSaveInXml",
        typeof(bool), DefaultNeedToSaveInXml,
        ConfigurationPropertyOptions.IsRequired);

    /// <summary>
    /// The needToSaveInXml configuration property.
    /// </summary>
    private static readonly ConfigurationProperty needToLearnFromXml =
        new ConfigurationProperty("needToLearnFromXml",
        typeof(bool), DefaultNeedToLearnFromXml,
        ConfigurationPropertyOptions.IsRequired);

    /// <summary>
    /// The serviceName configuration property.
    /// </summary>
    private static readonly ConfigurationProperty serviceName =
        new ConfigurationProperty("serviceName",
        typeof(string), DefaultServiceName,
        ConfigurationPropertyOptions.IsRequired);

    #endregion

    #region Constructor

    /// <summary>
    /// Constructor.
    /// </summary>
    public UznavaykoServiceConfig()
    {
      // Property initialization
      properties = new ConfigurationPropertyCollection();
      properties.Add(learningMode);
      properties.Add(notifyAboutErrors);
      properties.Add(needToSaveInXml);
      properties.Add(needToLearnFromXml);
      properties.Add(serviceName);
    }

    #endregion

    #region Protected properties
    /// <summary>
    /// This is a key customization. It returns the initialized property bag.
    /// </summary>
    protected override ConfigurationPropertyCollection Properties
    {
      get { return properties; }
    }
    #endregion

    #region Public properties

    /// <summary>
    /// LearningMode.
    /// </summary>
    public bool LearningMode
    {
      get { return (bool)this[learningMode.Name]; }
      set { this[learningMode.Name] = value; }
    }

    /// <summary>
    /// NotifyAboutErrors.
    /// </summary>
    public bool NotifyAboutErrors
    {
      get { return (bool)this[notifyAboutErrors.Name]; }
      set { this[notifyAboutErrors.Name] = value; }
    }

    /// <summary>
    /// Gets or sets a value indicating whether service will save collected data
    /// in XML file or only in data file.
    /// </summary>
    /// <value><c>true</c> saving data in XML and DAT files, 
    /// <c>false</c> saving only in DAT files.</value>
    public bool NeedToSaveInXml
    {
      get { return (bool)this[needToSaveInXml.Name]; }
      set { this[needToSaveInXml.Name] = value; }
    }

    /// <summary>
    /// Gets or sets a value indicating whether service will learn neyron network
    /// with XML file or only will load the data files.
    /// </summary>
    public bool NeedToLearnFromXml
    {
      get { return (bool)this[needToLearnFromXml.Name]; }
      set { this[needToLearnFromXml.Name] = value; }
    }


    /// <summary>
    /// ServiceName
    /// </summary>
    [StringValidator(MinLength = 1, MaxLength = 20)]
    public string ServiceName
    {
      get { return (string)this[serviceName.Name]; }
      set { this[serviceName.Name] = value; }
    }

    #endregion
  }//end UznavaykoServiceConfig
}
