﻿using System.Runtime.Serialization;
using System.ServiceModel;

namespace Utils.Service
{
  /// <summary>
  /// Interface for retrieving information about Uznavaykos state.
  /// </summary>
  [ServiceContract]
  public interface IService
  {
    /// <summary>
    /// Gets the status of the Uznavaykos neyron state.
    /// </summary>
    /// <returns></returns>
    [OperationContract]
    Status GetStatus();
  }

  [DataContract]
  public enum Status
  {
    [EnumMemberAttribute]
    Error,
    [EnumMemberAttribute]
    Warning,
    [EnumMemberAttribute]
    Ok
  }
}
