using System;
using System.Collections;

namespace HarryBonesSolutions.Performance
{
	/// <summary>
	/// A collection of <see cref="ExecutionTimer"/> objects.
	/// </summary>
	public class ExecutionTimerCollection : CollectionBase
	{
		/// <summary>
		/// Initializes a new instance of the <see cref="ExecutionTimerCollection"/>
		///  class.
		/// </summary>
		public ExecutionTimerCollection() : base(){}

		/// <summary>
		/// Adds an <see cref="ExecutionTimer"/> to the collection.
		/// </summary>
		/// <param name="timer"><see cref="ExecutionTimer"/> to be added to the collection.</param>
		/// <returns>The index of the <see cref="ExecutionTimer"/> after being added to the collection.</returns>
		/// <exception cref="NameExistsException">An <see cref="ExecutionTimer"/> 
		/// the same name as the timer argument already exists in the collection.</exception>
		public int Add(ExecutionTimer timer)
		{
			string name = timer.Name;

			foreach(object o in List)
			{
				if(((ExecutionTimer)o).Name == name)
					throw new NameExistsException("An ExecutionTimer with the name " + 
						name + " already exists in the collection", name);
			}

			return List.Add(timer);
		}

		/// <summary>
		/// Gets or sets the <see cref="ExecutionTimer"/> at the specified index.
		/// </summary>
		public ExecutionTimer this[int index]
		{
			get
			{
				return (ExecutionTimer)List[index];
			}
			set
			{
				List[index] = value;
			}
		}

		/// <summary>
		/// Gets or sets the <see cref="ExecutionTimer"/> with the specified name.
		/// </summary>
		/// <exception cref="ArgumentOutOfRangeException">No <see cref="ExecutionTimer"/> 
		/// with the specified name exists in the collection.</exception>
		public ExecutionTimer this[string name]
		{
			get
			{
				for(int i = 0; i < List.Count; i++)
				{
					if(((ExecutionTimer)List[i]).Name == name)
						return (ExecutionTimer)List[i];
				}

				throw new ArgumentOutOfRangeException("name", name, string.Format(
					"{0} is not a member of the collection.", name));
			}
			set
			{
				for(int i = 0; i < Count; i++)
				{
					if(((ExecutionTimer)List[i]).Name == name)
					{
						List[i] = value;
						return;
					}
				}

				throw new ArgumentOutOfRangeException("name", name, string.Format(
					"{0} is not a member of the collection."));
			}
		}

		/// <summary>
		/// Determines whether the ExecutionTimerCollection contains the specified ExecutionTimer.
		/// </summary>
		/// <param name="timer">The ExecutionTimer to locate in the collection.</param>
		/// <returns><c>true</c> if the ExecutionTimerCollection contains the ExecutionTimer.  Otherwise, <c>false</c></returns>
		public bool Contains(ExecutionTimer timer)
		{
			foreach(object o in List)
			{
				if(o == timer)
					return true;
			}

			return false;
		}

		/// <summary>
		/// Determines whether the ExecutionTimerCollection contains an ExecutionTimer with
		/// the specified name.
		/// </summary>
		/// <param name="timerName">The ExecutionTimer to locate in the collection.</param>
		/// <returns><c>true</c> if the ExecutionTimerCollection contain an ExecutionTimer 
		/// with the specified name.  Otherwise, <c>false</c></returns>
		public bool ContainsName(string timerName)
		{
			foreach(object o in List)
			{
				if(((ExecutionTimer)o).Name == timerName)
					return true;
			}

			return false;
		}
	}
}