using System;
using System.Collections.Generic;
using System.Text;
using NeuronDotNet.Core;
using NeuronDotNet.Core.SOM;
using System.Runtime.Serialization.Formatters.Binary;
using System.IO;
using MouseAnalyzer.Properties;

namespace MouseAnalyzer.SecurityAlgorithms
{
    class NeuroNetAlgorithm : ISecurityAlgorithm
    {
        private KohonenNetwork _kohonenNetwork;
        private int _iteration;

        private int _trainingEpoch;
        public int TrainingEpoch
        {
            get { return _trainingEpoch; }
            set { _trainingEpoch = value; }
        }

        public NeuroNetAlgorithm()
        {
            _kohonenNetwork = null;
            _trainingEpoch = 0;
            _iteration = 0;
        }

        private NeuroNetAlgorithm(KohonenNetwork network)
        {
            _kohonenNetwork = network;
            _trainingEpoch = network.JitterEpoch + 1;
            _iteration = 0;
        }

        private KohonenNetwork CreateNewNetwork(int inputLayerNeuronsCount)
        {
            KohonenLayer inputLayer = new KohonenLayer(inputLayerNeuronsCount);
            KohonenLayer hiddenLayer = new KohonenLayer(inputLayerNeuronsCount);
            KohonenLayer outputLayer = new KohonenLayer(1);
            KohonenConnector layer1To2Connector = new KohonenConnector(inputLayer, hiddenLayer);
            KohonenConnector layer2To3Connector = new KohonenConnector(hiddenLayer, outputLayer);
            KohonenNetwork _kohonenNetwork = new KohonenNetwork(inputLayer, outputLayer);
            _kohonenNetwork.SetLearningRate(0.5);
            return _kohonenNetwork;
        }

        #region ISecurityAlgorithm Members

        public void LearnVector(double[] vector)
        {
            //        .
            if (_kohonenNetwork == null)
            {
                _kohonenNetwork = CreateNewNetwork(vector.Length);
            }
            try
            {
                _kohonenNetwork.Learn(new TrainingSample(vector), _iteration, _trainingEpoch);
            }
            //      -     ...
            catch (ArgumentException)
            {

            }
            _iteration++;
        }

        public double CheckVector(double[] vector)
        {
            double[] result = _kohonenNetwork.Run(vector);
            return result[0];
        }

        public void Save(string fileName)
        {
            BinaryFormatter binFormatter = new BinaryFormatter();
            // TODO:   exception -  
            using (FileStream fileStream = new FileStream(fileName, FileMode.CreateNew))
            {
                binFormatter.Serialize(fileStream, _kohonenNetwork);
            }
        }

        public void Load(string fileName)
        {
            BinaryFormatter binFormatter = new BinaryFormatter();
            // TODO:   exception -  
            using (FileStream fileStream = new FileStream(fileName, FileMode.Open))
            {
                _kohonenNetwork = (KohonenNetwork)binFormatter.Deserialize(fileStream);
            }
            _iteration = 0;
            _kohonenNetwork.JitterEpoch += 1;
            _trainingEpoch = _kohonenNetwork.JitterEpoch;
            
        }

        public string Name
        {
            get { return Resources.NeuronSecurityAlgorithmName; }
        }

        public string Description
        {
            get { throw new Exception("The method or operation is not implemented."); }
        }

        #endregion
    }
}
