﻿using System;
using System.Collections.Generic;

namespace XmlSerialization
{
  public class XmlPasswordData
  {
    private Word word;

    private string fileName = "DefaultPassword.xml";

    private static XmlSerialization xml;

    public XmlPasswordData(string fileName)
    {
      word = new Word();
      word.dateTime = DateTime.Now;
      this.fileName = fileName;
    }

    public XmlPasswordData(Word wordData, string fileName)
    {
      word = wordData;
      this.fileName = fileName;
    }

    public int Length
    {
      get
      {
        return word.notes.Length;
      }
    }

    public int[] ToIntArray()
    {
      int[] array = new int[Length];
      for (int i = 0; i < Length; i++)
      {
        array[i] = (int)word.notes[i].characterCode;
      }
      return array;
    }

    public Note this[int index]
    {
      get
      {
        return word.notes[index];
      }
      set
      {
        word.notes[index] = value;
      }
    }

    public void AddItem(Note note)
    {
      List<Note> notes = new List<Note>(word.notes);
      notes.Add(note);
      word.notes = notes.ToArray();
    }

    /// <summary>
    /// Gets the collection of all notes.
    /// </summary>
    /// <value>The notes.</value>
    public IEnumerable<Note> Notes
    {
      get
      {
        foreach (var note in word.notes)
        {
          yield return note;
        }
      } 
    }

    /// <summary>
    /// Gets the millisecods from millisecond.
    /// </summary>
    /// <returns></returns>
    public long[] GetMillisecods()
    {
      return new List<long>(word.GetMillisecods()).ToArray();
    }

    /// <summary>
    /// Gets the date time from word.
    /// </summary>
    /// <returns></returns>
    public DateTime GetDateTime()
    {
      return word.dateTime;
    }

    /// <summary>
    /// Saves word in xml file.
    /// </summary>
    public void Save()
    {
      if (xml == null)
      {
        xml = new XmlSerialization(fileName);
      }
      xml.AddNote(word);
      xml.WriteToFile();
    }

    /// <summary>
    /// Reads the XML file and returns List of words.
    /// </summary>
    /// <param name="fileName">Name of the file.</param>
    /// <returns></returns>
    public static List<XmlPasswordData> ReadXml(string fileName)
    {
      Word[] words;
      using (XmlSerialization xmlFile = new XmlSerialization(fileName))
      {
        words = xmlFile.NoteList.Words;
      }

      List<XmlPasswordData> pases = new List<XmlPasswordData>();

      foreach (Word pas in words)
      {
        pases.Add(new XmlPasswordData(pas, fileName));
      }

      return pases;
    }

  }
}
