﻿using System;
using System.Collections.Generic;
using System.Xml.Serialization;
using System.Collections;

namespace XmlSerialization
{

  [XmlRootAttribute("UznavaykoPasFile",Namespace = "http://vkontakte.ru/id33280?79715",IsNullable = false)]  
  public sealed class UznavaykoPasFile
  {
    /// <summary>
    /// collection of notes.
    /// </summary>
    private ArrayList listNotes;

    /// <summary>
    /// Gets or sets the notes array.
    /// </summary>
    /// <value>The notes.</value>
    [XmlArrayAttribute("words")]
    public Word[] Words
    {
      get
      {
        Word[] items = new Word[listNotes.Count];
        listNotes.CopyTo(items);
        return items;
      }
      set
      {
        if (value == null) return;
        Word[] items = value;
        listNotes.Clear();
        foreach (Word item in items)
          listNotes.Add(item);
      }
    }

    /// <summary>
    /// Initializes a new instance of the <see cref="NotesInXML"/> class.
    /// </summary>
    internal UznavaykoPasFile()
    {
      listNotes = new ArrayList();
    }

    /// <summary>
    /// Adds the item.
    /// </summary>
    /// <param name="item">The item.</param>
    /// <returns></returns>
    internal int AddItem(Word item)
    {
      if (item.Id == 0 && listNotes.Count > 0)
      {
        Int64 id = ((Word)listNotes[listNotes.Count - 1]).Id;
        item.Id = id + 1;        
      }
      return listNotes.Add(item);
    }

    /// <summary>
    /// Deletes the item.
    /// </summary>
    /// <param name="item">The item.</param>
    internal void DeleteItem(Word item)
    {
      foreach (Word note in listNotes)
      {
        if (note.Id == item.Id)
        {
          listNotes.Remove(note);
          break;
        }
      }
    }   
  }
}
