﻿using System;
using System.Collections.Generic;
using System.ServiceModel;
using Utils.Service;

namespace Uznavayko.UznavaykoKeyboard.Service
{
  /// <summary>
  /// Server that provides info about Uznavaykos work via WCF.
  /// </summary>
  [ServiceBehavior(InstanceContextMode = InstanceContextMode.Single)]
  public class StateProvider : IService
  {
    private double errors = 1;
    private double success = 1;

    /// <summary>
    /// Gets or sets a value indicating whether [error state].
    /// </summary>
    /// <value><c>true</c> if [error state]; otherwise, <c>false</c>.</value>
    public bool NoErrors
    {
      set
      {
        if (value)
        {
          success++;
        }
        else
        {
          errors++;
        }
        if (success > 50 || errors > 50)
        {
          success /= 2;
          errors /= 2;
        }
      }
    }

    #region IService Members

    /// <summary>
    /// Gets the status.
    /// </summary>
    /// <returns></returns>
    public Status GetStatus()
    {
      if (errors / (errors + success) > 0.60)
      {
        return Status.Error;
      }

      if (errors / (errors + success) < 0.55)
      {
        return Status.Ok;
      }

      return Status.Warning;
    }

    #endregion
  }
}
